/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenidePageFactory;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.JavaScriptErrorsFound;
import com.codeborne.selenide.impl.DownloadFileWithHttpRequest;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.JavascriptErrorsCollector;
import com.codeborne.selenide.impl.Modals;
import com.codeborne.selenide.impl.Navigator;
import com.codeborne.selenide.impl.SelenideWait;
import com.codeborne.selenide.impl.WebDriverLogs;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class Selenide {
    public static Navigator navigator = new Navigator();
    private static JavascriptErrorsCollector javascriptErrorsCollector = new JavascriptErrorsCollector();
    private static WebDriverLogs webDriverLogs = new WebDriverLogs();
    private static Modals modals = new Modals();
    private static SelenidePageFactory pageFactory = new SelenidePageFactory();
    private static DownloadFileWithHttpRequest downloadFileWithHttpRequest = new DownloadFileWithHttpRequest();

    public static void open(String relativeOrAbsoluteUrl) {
        Selenide.open(relativeOrAbsoluteUrl, "", "", "");
    }

    public static void open(URL absoluteUrl) {
        Selenide.open(absoluteUrl, "", "", "");
    }

    public static void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        navigator.open(relativeOrAbsoluteUrl, domain, login, password);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, String login, String password) {
        Credentials credentials = new Credentials(login, password);
        Selenide.open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        navigator.open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(URL absoluteUrl, String domain, String login, String password) {
        navigator.open(absoluteUrl, domain, login, password);
    }

    public static void updateHash(String hash) {
        String localHash = hash.charAt(0) == '#' ? hash.substring(1) : hash;
        Selenide.executeJavaScript("window.location.hash='" + localHash + "'", new Object[0]);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return Selenide.open(relativeOrAbsoluteUrl, "", "", "", pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return Selenide.open(absoluteUrl, "", "", "", pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        Selenide.open(relativeOrAbsoluteUrl, domain, login, password);
        return Selenide.page(pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        Selenide.open(absoluteUrl, domain, login, password);
        return Selenide.page(pageObjectClassClass);
    }

    public static void close() {
        WebDriverRunner.closeWebDriver();
    }

    public static void refresh() {
        navigator.refresh();
    }

    public static void back() {
        navigator.back();
    }

    public static void forward() {
        navigator.forward();
    }

    public static String title() {
        return WebDriverRunner.getWebDriver().getTitle();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static String screenshot(String fileName) {
        return Screenshots.takeScreenShot(fileName);
    }

    public static SelenideElement $(WebElement webElement) {
        return WebElementWrapper.wrap(webElement);
    }

    public static SelenideElement $(String cssSelector) {
        return Selenide.getElement(By.cssSelector((String)cssSelector));
    }

    public static SelenideElement $x(String xpathExpression) {
        return Selenide.getElement(By.xpath((String)xpathExpression));
    }

    public static SelenideElement $(By seleniumSelector) {
        return Selenide.getElement(seleniumSelector);
    }

    public static SelenideElement $(By seleniumSelector, int index) {
        return Selenide.getElement(seleniumSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, String cssSelector) {
        return ElementFinder.wrap(parent, cssSelector);
    }

    public static SelenideElement $(String cssSelector, int index) {
        return ElementFinder.wrap(cssSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, String cssSelector, int index) {
        return ElementFinder.wrap(parent, cssSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, By seleniumSelector) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), seleniumSelector, 0);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, By seleniumSelector, int index) {
        return ElementFinder.wrap((SearchContext)Selenide.$(parent), seleniumSelector, index);
    }

    public static ElementsCollection $$(Collection<? extends WebElement> elements) {
        return new ElementsCollection(elements);
    }

    public static ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(cssSelector);
    }

    public static ElementsCollection $$x(String xpathExpression) {
        return Selenide.$$(By.xpath((String)xpathExpression));
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return new ElementsCollection(seleniumSelector);
    }

    @Deprecated
    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return new ElementsCollection(parent, cssSelector);
    }

    @Deprecated
    public static ElementsCollection $$(WebElement parent, By seleniumSelector) {
        return new ElementsCollection(parent, seleniumSelector);
    }

    public static SelenideElement getElement(By criteria) {
        return ElementFinder.wrap(null, criteria, 0);
    }

    public static SelenideElement getElement(By criteria, int index) {
        return ElementFinder.wrap(null, criteria, index);
    }

    public static ElementsCollection getElements(By criteria) {
        return Selenide.$$(criteria);
    }

    public static <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return (T)((JavascriptExecutor)WebDriverRunner.getWebDriver()).executeScript(jsCode, arguments);
    }

    @Deprecated
    public static SelenideElement selectRadio(By radioField, String value) {
        return Selenide.$(radioField).selectRadio(value);
    }

    public static SelenideElement getSelectedRadio(By radioField) {
        for (WebElement radio : Selenide.$$(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return WebElementWrapper.wrap(radio);
        }
        return null;
    }

    public static String confirm() {
        return modals.confirm();
    }

    public static String confirm(String expectedDialogText) {
        return modals.confirm(expectedDialogText);
    }

    public static String prompt() {
        return modals.prompt();
    }

    public static String prompt(String inputText) {
        return modals.prompt(inputText);
    }

    public static String prompt(String expectedDialogText, String inputText) {
        return modals.prompt(expectedDialogText, inputText);
    }

    public static String dismiss() {
        return modals.dismiss();
    }

    public static String dismiss(String expectedDialogText) {
        return modals.dismiss(expectedDialogText);
    }

    public static SelenideTargetLocator switchTo() {
        return new SelenideTargetLocator(WebDriverRunner.getWebDriver().switchTo());
    }

    public static WebElement getFocusedElement() {
        return (WebElement)Selenide.executeJavaScript("return document.activeElement", new Object[0]);
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return pageFactory.page(WebDriverRunner.getWebDriver(), pageObjectClass);
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return pageFactory.page(WebDriverRunner.getWebDriver(), pageObject);
    }

    public static SelenideWait Wait() {
        return new SelenideWait(WebDriverRunner.getWebDriver());
    }

    public static Actions actions() {
        return new Actions(WebDriverRunner.getWebDriver());
    }

    public static List<String> getJavascriptErrors() {
        return javascriptErrorsCollector.getJavascriptErrors();
    }

    public static void assertNoJavascriptErrors() throws JavaScriptErrorsFound {
        List<String> jsErrors = Selenide.getJavascriptErrors();
        if (jsErrors != null && !jsErrors.isEmpty()) {
            throw new JavaScriptErrorsFound(jsErrors);
        }
    }

    public static void zoom(double factor) {
        Selenide.executeJavaScript("document.body.style.transform = 'scale(' + arguments[0] + ')';document.body.style.transformOrigin = '0 0';", factor);
    }

    public static List<String> getWebDriverLogs(String logType) {
        return Selenide.getWebDriverLogs(logType, Level.ALL);
    }

    public static List<String> getWebDriverLogs(String logType, Level logLevel) {
        return webDriverLogs.getWebDriverLogs(WebDriverRunner.getWebDriver(), logType, logLevel);
    }

    public static void clearBrowserCookies() {
        WebDriverRunner.getWebDriver().manage().deleteAllCookies();
    }

    public static void clearBrowserLocalStorage() {
        Selenide.executeJavaScript("localStorage.clear();", new Object[0]);
    }

    public static String getUserAgent() {
        return (String)Selenide.executeJavaScript("return navigator.userAgent;", new Object[0]);
    }

    public static boolean atBottom() {
        return (Boolean)Selenide.executeJavaScript("return window.pageYOffset + window.innerHeight >= document.body.scrollHeight", new Object[0]);
    }

    public static File download(String url) throws IOException {
        return Selenide.download(url, Configuration.timeout);
    }

    public static File download(String url, long timeoutMs) throws IOException {
        return downloadFileWithHttpRequest.download(url, timeoutMs);
    }
}

