/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ex.ListSizeMismatch;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import org.openqa.selenium.WebElement;

public class SizeGreaterThanOrEqual
extends CollectionCondition {
    protected final int expectedSize;

    public SizeGreaterThanOrEqual(int expectedSize) {
        this.expectedSize = expectedSize;
    }

    public boolean apply(List<WebElement> elements) {
        return elements.size() >= this.expectedSize;
    }

    @Override
    public void fail(WebElementsCollection collection, List<WebElement> elements, Exception lastError, long timeoutMs) {
        throw new ListSizeMismatch(">=", this.expectedSize, this.explanation, collection, elements, lastError, timeoutMs);
    }

    public String toString() {
        return String.format("size >= %s", this.expectedSize);
    }
}

