/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.ex.DialogTextMismatch;
import org.openqa.selenium.Alert;

public class Modals {
    public String confirm() {
        return this.confirm(null);
    }

    public String confirm(String expectedDialogText) {
        Alert alert = Selenide.switchTo().alert();
        String actualDialogText = alert.getText();
        alert.accept();
        Modals.checkDialogText(expectedDialogText, actualDialogText);
        return actualDialogText;
    }

    public String prompt() {
        return this.prompt(null, null);
    }

    public String prompt(String inputText) {
        return this.prompt(null, inputText);
    }

    public String prompt(String expectedDialogText, String inputText) {
        Alert alert = Selenide.switchTo().alert();
        String actualDialogText = alert.getText();
        if (inputText != null) {
            alert.sendKeys(inputText);
        }
        alert.accept();
        Modals.checkDialogText(expectedDialogText, actualDialogText);
        return actualDialogText;
    }

    public String dismiss() {
        return this.dismiss(null);
    }

    public String dismiss(String expectedDialogText) {
        Alert alert = Selenide.switchTo().alert();
        String actualDialogText = alert.getText();
        alert.dismiss();
        Modals.checkDialogText(expectedDialogText, actualDialogText);
        return actualDialogText;
    }

    private static void checkDialogText(String expectedDialogText, String actualDialogText) {
        if (expectedDialogText != null && !expectedDialogText.equals(actualDialogText)) {
            Screenshots.takeScreenShot(Selenide.class.getName(), Thread.currentThread().getName());
            throw new DialogTextMismatch(actualDialogText, expectedDialogText);
        }
    }
}

