/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openqa.selenium.Alert;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.UnreachableBrowserException;

public class ScreenShotLaboratory {
    private static final Logger log = Logger.getLogger(ScreenShotLaboratory.class.getName());
    protected final List<File> allScreenshots = new ArrayList<File>();
    protected AtomicLong screenshotCounter = new AtomicLong();
    protected ThreadLocal<String> currentContext = ThreadLocal.withInitial(() -> "");
    protected ThreadLocal<List<File>> currentContextScreenshots = new ThreadLocal();
    protected Set<String> printedErrors = new ConcurrentSkipListSet<String>();

    public String takeScreenShot(String className, String methodName) {
        return this.takeScreenShot(this.getScreenshotFileName(className, methodName));
    }

    protected String getScreenshotFileName(String className, String methodName) {
        return className.replace('.', File.separatorChar) + File.separatorChar + methodName + '.' + this.timestamp();
    }

    public String takeScreenShot() {
        return this.takeScreenShot(this.generateScreenshotFileName());
    }

    public String takeScreenShot(String fileName) {
        File imageFile;
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        File screenshot = null;
        if (Configuration.savePageSource) {
            screenshot = this.savePageSourceToFile(fileName, webdriver);
        }
        if ((imageFile = this.savePageImageToFile(fileName, webdriver)) != null) {
            screenshot = imageFile;
        }
        if (screenshot == null) {
            return null;
        }
        return this.addToHistory(screenshot).getAbsolutePath();
    }

    public File takeScreenshot(WebElement element) {
        try {
            BufferedImage dest = this.takeScreenshotAsImage(element);
            File screenshotOfElement = new File(Configuration.reportsFolder, this.generateScreenshotFileName() + ".png");
            this.ensureFolderExists(screenshotOfElement);
            ImageIO.write((RenderedImage)dest, "png", screenshotOfElement);
            return screenshotOfElement;
        }
        catch (IOException e) {
            this.printOnce("takeScreenshot", e);
            return null;
        }
    }

    public BufferedImage takeScreenshotAsImage(WebElement element) {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        if (!(webdriver instanceof TakesScreenshot)) {
            log.warning("Cannot take screenshot because browser does not support screenshots");
            return null;
        }
        byte[] screen = (byte[])((TakesScreenshot)webdriver).getScreenshotAs(OutputType.BYTES);
        Point elementLocation = element.getLocation();
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(screen));
            int elementWidth = element.getSize().getWidth();
            int elementHeight = element.getSize().getHeight();
            if (elementWidth > img.getWidth()) {
                elementWidth = img.getWidth() - elementLocation.getX();
            }
            if (elementHeight > img.getHeight()) {
                elementHeight = img.getHeight() - elementLocation.getY();
            }
            return img.getSubimage(elementLocation.getX(), elementLocation.getY(), elementWidth, elementHeight);
        }
        catch (IOException e) {
            this.printOnce("takeScreenshotImage", e);
            return null;
        }
        catch (RasterFormatException e) {
            log.warning("Cannot take screenshot because element is not displayed on current screen position");
            return null;
        }
    }

    protected String generateScreenshotFileName() {
        return this.currentContext.get() + this.timestamp() + "." + this.screenshotCounter.getAndIncrement();
    }

    protected File ensureFolderExists(File targetFile) {
        File folder = targetFile.getParentFile();
        if (!folder.exists()) {
            log.info("Creating folder: " + folder);
            if (!folder.mkdirs()) {
                log.severe("Failed to create " + folder);
            }
        }
        return targetFile;
    }

    protected synchronized void printOnce(String action, Throwable error) {
        if (!this.printedErrors.contains(action)) {
            log.log(Level.SEVERE, error.getMessage(), error);
            this.printedErrors.add(action);
        } else {
            log.severe("Failed to " + action + ": " + error);
        }
    }

    protected long timestamp() {
        return System.currentTimeMillis();
    }

    public File takeScreenshot(WebElement iframe, WebElement element) {
        try {
            BufferedImage dest = this.takeScreenshotAsImage(iframe, element);
            if (dest == null) {
                return null;
            }
            File screenshotOfElement = new File(Configuration.reportsFolder, this.generateScreenshotFileName() + ".png");
            this.ensureFolderExists(screenshotOfElement);
            ImageIO.write((RenderedImage)dest, "png", screenshotOfElement);
            return screenshotOfElement;
        }
        catch (IOException e) {
            this.printOnce("takeScreenshot", e);
            return null;
        }
    }

    public BufferedImage takeScreenshotAsImage(WebElement iframe, WebElement element) {
        BufferedImage img;
        WebDriver webdriver = this.checkIfFullyValidDriver();
        if (webdriver == null) {
            return null;
        }
        byte[] screen = (byte[])((TakesScreenshot)webdriver).getScreenshotAs(OutputType.BYTES);
        Point iframeLocation = iframe.getLocation();
        try {
            img = ImageIO.read(new ByteArrayInputStream(screen));
        }
        catch (IOException e) {
            this.printOnce("takeScreenshotImage", e);
            return null;
        }
        catch (RasterFormatException ex) {
            log.warning("Cannot take screenshot because iframe is not displayed");
            return null;
        }
        int iframeHeight = iframe.getSize().getHeight();
        Selenide.switchTo().frame(iframe);
        int iframeWidth = ((Long)((JavascriptExecutor)webdriver).executeScript("return document.body.clientWidth", new Object[0])).intValue();
        if (iframeHeight > img.getHeight()) {
            iframeHeight = img.getHeight() - iframeLocation.getY();
        }
        if (iframeWidth > img.getWidth()) {
            iframeWidth = img.getWidth() - iframeLocation.getX();
        }
        Point elementLocation = element.getLocation();
        int elementWidth = element.getSize().getWidth();
        int elementHeight = element.getSize().getHeight();
        if (elementWidth > iframeWidth) {
            elementWidth = iframeWidth - elementLocation.getX();
        }
        if (elementHeight > iframeHeight) {
            elementHeight = iframeHeight - elementLocation.getY();
        }
        Selenide.switchTo().defaultContent();
        try {
            img = img.getSubimage(iframeLocation.getX() + elementLocation.getX(), iframeLocation.getY() + elementLocation.getY(), elementWidth, elementHeight);
        }
        catch (RasterFormatException ex) {
            log.warning("Cannot take screenshot because element is not displayed in iframe");
            return null;
        }
        return img;
    }

    private WebDriver checkIfFullyValidDriver() {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        if (!(webdriver instanceof TakesScreenshot)) {
            log.warning("Cannot take screenshot because browser does not support screenshots");
            return null;
        }
        if (!(webdriver instanceof JavascriptExecutor)) {
            log.warning("Cannot take screenshot as driver is not supporting javascript execution");
            return null;
        }
        return webdriver;
    }

    public File takeScreenShotAsFile() {
        if (!WebDriverRunner.hasWebDriverStarted()) {
            log.warning("Cannot take screenshot because browser is not started");
            return null;
        }
        WebDriver webdriver = WebDriverRunner.getWebDriver();
        File scrFile = this.getPageImage(webdriver);
        this.addToHistory(scrFile);
        return scrFile;
    }

    protected File getPageImage(WebDriver webdriver) {
        File scrFile = null;
        if (webdriver instanceof TakesScreenshot) {
            scrFile = this.takeScreenshotInMemory((TakesScreenshot)webdriver);
        }
        return scrFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File addToHistory(File screenshot) {
        if (this.currentContextScreenshots.get() != null) {
            this.currentContextScreenshots.get().add(screenshot);
        }
        List<File> list = this.allScreenshots;
        synchronized (list) {
            this.allScreenshots.add(screenshot);
        }
        return screenshot;
    }

    protected File takeScreenshotInMemory(TakesScreenshot driver) {
        try {
            return (File)driver.getScreenshotAs(OutputType.FILE);
        }
        catch (Exception e) {
            this.printOnce("takeScreenshotAsFile", e);
            return null;
        }
    }

    protected File savePageImageToFile(String fileName, WebDriver webdriver) {
        File imageFile = null;
        if (webdriver instanceof TakesScreenshot) {
            imageFile = this.takeScreenshotImage((TakesScreenshot)webdriver, fileName);
        }
        return imageFile;
    }

    protected File savePageSourceToFile(String fileName, WebDriver webdriver) {
        return this.savePageSourceToFile(fileName, webdriver, true);
    }

    protected File savePageSourceToFile(String fileName, WebDriver webdriver, boolean retryIfAlert) {
        File pageSource = new File(Configuration.reportsFolder, fileName + ".html");
        try {
            this.writeToFile(webdriver.getPageSource(), pageSource);
        }
        catch (UnhandledAlertException e) {
            if (retryIfAlert) {
                try {
                    Alert alert = webdriver.switchTo().alert();
                    log.severe((Object)((Object)e) + ": " + alert.getText());
                    alert.accept();
                    this.savePageSourceToFile(fileName, webdriver, false);
                }
                catch (Exception unableToCloseAlert) {
                    log.severe("Failed to close alert: " + unableToCloseAlert);
                }
            } else {
                this.printOnce("savePageSourceToFile", e);
            }
        }
        catch (UnreachableBrowserException e) {
            this.writeToFile(e.toString(), pageSource);
            return pageSource;
        }
        catch (Exception e) {
            this.writeToFile(e.toString(), pageSource);
            this.printOnce("savePageSourceToFile", e);
        }
        return pageSource;
    }

    protected File takeScreenshotImage(TakesScreenshot driver, String fileName) {
        try {
            File scrFile = (File)driver.getScreenshotAs(OutputType.FILE);
            File imageFile = new File(Configuration.reportsFolder, fileName + ".png");
            this.copyFile(scrFile, imageFile);
            return imageFile;
        }
        catch (Exception e) {
            this.printOnce("takeScreenshotImage", e);
            return null;
        }
    }

    protected void copyFile(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);){
            this.copyFile(in, targetFile);
        }
    }

    protected void copyFile(InputStream in, File targetFile) throws IOException {
        this.ensureFolderExists(targetFile);
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    protected void writeToFile(String content, File targetFile) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes("UTF-8"));){
            this.copyFile(in, targetFile);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to write file " + targetFile.getAbsolutePath(), e);
        }
    }

    public void startContext(String className, String methodName) {
        String context = className.replace('.', File.separatorChar) + File.separatorChar + methodName + File.separatorChar;
        this.startContext(context);
    }

    public void startContext(String context) {
        this.currentContext.set(context);
        this.currentContextScreenshots.set(new ArrayList());
    }

    public List<File> finishContext() {
        List<File> result = this.currentContextScreenshots.get();
        this.currentContext.set("");
        this.currentContextScreenshots.remove();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getScreenshots() {
        List<File> list = this.allScreenshots;
        synchronized (list) {
            return Collections.unmodifiableList(this.allScreenshots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getLastScreenshot() {
        List<File> list = this.allScreenshots;
        synchronized (list) {
            return this.allScreenshots.isEmpty() ? null : this.allScreenshots.get(this.allScreenshots.size() - 1);
        }
    }

    public String formatScreenShotPath() {
        if (!Configuration.screenshots) {
            log.config("Automatic screenshots are disabled.");
            return "";
        }
        String screenshot = this.takeScreenShot();
        if (screenshot == null) {
            return "";
        }
        if (Configuration.reportsUrl != null) {
            String screenshotRelativePath = screenshot.substring(System.getProperty("user.dir").length() + 1);
            String screenshotUrl = Configuration.reportsUrl + screenshotRelativePath.replace('\\', '/');
            try {
                screenshotUrl = new URL(screenshotUrl).toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            log.config("Replaced screenshot file path '" + screenshot + "' by public CI URL '" + screenshotUrl + "'");
            return screenshotUrl;
        }
        log.config("reportsUrl is not configured. Returning screenshot file name '" + screenshot + "'");
        try {
            return new File(screenshot).toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return "file://" + screenshot;
        }
    }
}

