/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.openqa.selenium.WebElement;

public class CollectionElementByCondition
extends WebElementSource {
    private final WebElementsCollection collection;
    private final Condition condition;

    public static SelenideElement wrap(WebElementsCollection collection, Condition condition) {
        return (SelenideElement)Proxy.newProxyInstance(collection.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new SelenideElementProxy(new CollectionElementByCondition(collection, condition)));
    }

    CollectionElementByCondition(WebElementsCollection collection, Condition condition) {
        this.collection = collection;
        this.condition = condition;
    }

    @Override
    public WebElement getWebElement() {
        List<WebElement> list = this.collection.getActualElements();
        for (WebElement element : list) {
            if (!this.condition.apply(element)) continue;
            return element;
        }
        throw new ElementNotFound(this.getSearchCriteria(), this.condition);
    }

    @Override
    public String getSearchCriteria() {
        return this.collection.description() + ".findBy(" + this.condition + ")";
    }

    @Override
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.collection.getActualElements().isEmpty()) {
            return new ElementNotFound(this.collection.description(), Condition.visible, lastError);
        }
        return super.createElementNotFoundError(condition, lastError);
    }

    public String toString() {
        return this.getSearchCriteria();
    }
}

