/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.impl.Describe;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebElement;

public class DownloadFileWithHttpRequest {
    private static final Logger log = Logger.getLogger(DownloadFileWithHttpRequest.class.getName());
    public static boolean ignoreSelfSignedCerts = true;

    public File download(WebElement element) throws IOException {
        String fileToDownloadLocation = element.getAttribute("href");
        if (fileToDownloadLocation == null || fileToDownloadLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("The element does not have href attribute: " + Describe.describe(element));
        }
        HttpResponse response = this.executeHttpRequest(fileToDownloadLocation);
        if (response.getStatusLine().getStatusCode() >= 500) {
            throw new RuntimeException("Failed to download file " + fileToDownloadLocation + ": " + response.getStatusLine());
        }
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new FileNotFoundException("Failed to download file " + fileToDownloadLocation + ": " + response.getStatusLine());
        }
        File downloadedFile = this.prepareTargetFile(fileToDownloadLocation, response);
        return this.saveFileContent(response, downloadedFile);
    }

    protected HttpResponse executeHttpRequest(String fileToDownloadLocation) throws IOException {
        CloseableHttpClient httpClient = ignoreSelfSignedCerts ? this.createTrustingHttpClient() : HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(fileToDownloadLocation);
        httpGet.setConfig(RequestConfig.custom().setConnectTimeout((int)Configuration.timeout).setSocketTimeout((int)Configuration.timeout).setConnectionRequestTimeout((int)Configuration.timeout).setRedirectsEnabled(true).setCircularRedirectsAllowed(true).setMaxRedirects(20).setCookieSpec("standard").build());
        BasicHttpContext localContext = new BasicHttpContext();
        localContext.setAttribute("http.cookie-store", (Object)this.mimicCookieState());
        return httpClient.execute((HttpUriRequest)httpGet, (HttpContext)localContext);
    }

    private CloseableHttpClient createTrustingHttpClient() throws IOException {
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            builder.setSslcontext(sslContext);
            X509HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            builder.setConnectionManager((HttpClientConnectionManager)connMgr);
            return builder.build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected File prepareTargetFile(String fileToDownloadLocation, HttpResponse response) throws MalformedURLException {
        return new File(Configuration.reportsFolder, this.getFileName(fileToDownloadLocation, response));
    }

    protected String getFileName(String fileToDownloadLocation, HttpResponse response) throws MalformedURLException {
        for (Header header : response.getAllHeaders()) {
            String fileName = this.getFileNameFromContentDisposition(header.getName(), header.getValue());
            if (fileName == null) continue;
            return fileName;
        }
        log.info("Cannot extract file name from http headers. Found headers: ");
        for (Header header : response.getAllHeaders()) {
            log.info(header.getName() + '=' + header.getValue());
        }
        return new URL(fileToDownloadLocation).getFile().replaceFirst("/|\\\\", "");
    }

    protected String getFileNameFromContentDisposition(String headerName, String headerValue) {
        if ("Content-Disposition".equalsIgnoreCase(headerName)) {
            Matcher regex = Pattern.compile(".*filename=\"?([^\"]*)\"?.*").matcher(headerValue);
            return regex.matches() ? regex.replaceFirst("$1") : null;
        }
        return null;
    }

    protected BasicCookieStore mimicCookieState() {
        Set seleniumCookieSet = WebDriverRunner.getWebDriver().manage().getCookies();
        BasicCookieStore mimicWebDriverCookieStore = new BasicCookieStore();
        for (Cookie seleniumCookie : seleniumCookieSet) {
            mimicWebDriverCookieStore.addCookie((org.apache.http.cookie.Cookie)this.duplicateCookie(seleniumCookie));
        }
        return mimicWebDriverCookieStore;
    }

    protected BasicClientCookie duplicateCookie(Cookie seleniumCookie) {
        BasicClientCookie duplicateCookie = new BasicClientCookie(seleniumCookie.getName(), seleniumCookie.getValue());
        duplicateCookie.setDomain(seleniumCookie.getDomain());
        duplicateCookie.setAttribute("domain", seleniumCookie.getDomain());
        duplicateCookie.setSecure(seleniumCookie.isSecure());
        duplicateCookie.setExpiryDate(seleniumCookie.getExpiry());
        duplicateCookie.setPath(seleniumCookie.getPath());
        return duplicateCookie;
    }

    protected File saveFileContent(HttpResponse response, File downloadedFile) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)downloadedFile);
        return downloadedFile;
    }

    private static class TrustAllStrategy
    implements TrustStrategy {
        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] arg0, String arg1) {
            return true;
        }
    }
}

