/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import com.codeborne.selenide.webdriver.WebDriverFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainer
implements WebDriverContainer {
    private static final Logger log = Logger.getLogger(WebDriverThreadLocalContainer.class.getName());
    protected WebDriverFactory factory = new WebDriverFactory();
    protected List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    protected Collection<Thread> ALL_WEB_DRIVERS_THREADS = new ConcurrentLinkedQueue<Thread>();
    protected Map<Long, WebDriver> THREAD_WEB_DRIVER = new ConcurrentHashMap<Long, WebDriver>(4);
    protected Map<Long, SelenideProxyServer> THREAD_PROXY_SERVER = new ConcurrentHashMap<Long, SelenideProxyServer>(4);
    protected Proxy proxy;
    protected final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);

    protected void closeUnusedWebdrivers() {
        for (Thread thread : this.ALL_WEB_DRIVERS_THREADS) {
            if (thread.isAlive()) continue;
            log.info("Thread " + thread.getId() + " is dead. Let's close webdriver " + this.THREAD_WEB_DRIVER.get(thread.getId()));
            this.closeWebDriver(thread);
        }
    }

    @Override
    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public WebDriver setWebDriver(WebDriver webDriver) {
        this.THREAD_WEB_DRIVER.put(Thread.currentThread().getId(), webDriver);
        return webDriver;
    }

    @Override
    public void setProxy(Proxy webProxy) {
        this.proxy = webProxy;
    }

    protected boolean isBrowserStillOpen(WebDriver webDriver) {
        try {
            webDriver.getTitle();
            return true;
        }
        catch (UnreachableBrowserException e) {
            log.log(Level.FINE, "Browser is unreachable", e);
            return false;
        }
        catch (NoSuchWindowException e) {
            log.log(Level.FINE, "Browser window is not found", e);
            return false;
        }
        catch (NoSuchSessionException e) {
            log.log(Level.FINE, "Browser session is not found", e);
            return false;
        }
    }

    @Override
    public boolean hasWebDriverStarted() {
        return this.THREAD_WEB_DRIVER.containsKey(Thread.currentThread().getId());
    }

    @Override
    public WebDriver getWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            return webDriver;
        }
        log.info("No webdriver is bound to current thread: " + Thread.currentThread().getId() + " - let's create new webdriver");
        return this.setWebDriver(this.createDriver());
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        WebDriver webDriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webDriver != null) {
            if (!Configuration.reopenBrowserOnFail || this.isBrowserStillOpen(webDriver)) {
                return webDriver;
            }
            log.info("Webdriver has been closed meanwhile. Let's re-create it.");
            this.closeWebDriver();
        }
        return this.setWebDriver(this.createDriver());
    }

    @Override
    public SelenideProxyServer getProxyServer() {
        return this.THREAD_PROXY_SERVER.get(Thread.currentThread().getId());
    }

    @Override
    public void closeWebDriver() {
        this.closeWebDriver(Thread.currentThread());
    }

    protected void closeWebDriver(Thread thread) {
        this.ALL_WEB_DRIVERS_THREADS.remove(thread);
        WebDriver webdriver = this.THREAD_WEB_DRIVER.remove(thread.getId());
        SelenideProxyServer proxy = this.THREAD_PROXY_SERVER.remove(thread.getId());
        if (webdriver != null && !Configuration.holdBrowserOpen) {
            log.info("Close webdriver: " + thread.getId() + " -> " + webdriver);
            log.info("Close proxy server: " + thread.getId() + " -> " + proxy);
            long start = System.currentTimeMillis();
            Thread t = new Thread(new CloseBrowser(webdriver, proxy));
            t.setDaemon(true);
            t.start();
            try {
                t.join(Configuration.closeBrowserTimeoutMs);
            }
            catch (InterruptedException e) {
                log.log(Level.FINE, "Failed to close webdriver in " + Configuration.closeBrowserTimeoutMs + " milliseconds", e);
            }
            long duration = System.currentTimeMillis() - start;
            if (duration >= Configuration.closeBrowserTimeoutMs) {
                log.severe("Failed to close webdriver in " + Configuration.closeBrowserTimeoutMs + " milliseconds");
            } else if (duration > 200L) {
                log.info("Closed webdriver in " + duration + " ms");
            } else {
                log.fine("Closed webdriver in " + duration + " ms");
            }
        } else if (proxy != null && !Configuration.holdBrowserOpen) {
            log.info("Close proxy server: " + thread.getId() + " -> " + proxy);
            proxy.shutdown();
        }
    }

    @Override
    public void clearBrowserCache() {
        WebDriver webdriver = this.THREAD_WEB_DRIVER.get(Thread.currentThread().getId());
        if (webdriver != null) {
            webdriver.manage().deleteAllCookies();
        }
    }

    @Override
    public String getPageSource() {
        return this.getWebDriver().getPageSource();
    }

    @Override
    public String getCurrentUrl() {
        return this.getWebDriver().getCurrentUrl();
    }

    @Override
    public String getCurrentFrameUrl() {
        return ((JavascriptExecutor)this.getWebDriver()).executeScript("return window.location.href", new Object[0]).toString();
    }

    protected WebDriver createDriver() {
        Proxy userProvidedProxy = this.proxy;
        if (Configuration.fileDownload == Configuration.FileDownloadMode.PROXY) {
            SelenideProxyServer selenideProxyServer = new SelenideProxyServer(this.proxy);
            selenideProxyServer.start();
            this.THREAD_PROXY_SERVER.put(Thread.currentThread().getId(), selenideProxyServer);
            userProvidedProxy = selenideProxyServer.createSeleniumProxy();
        }
        WebDriver webdriver = this.factory.createWebDriver(userProvidedProxy);
        log.info("Create webdriver in current thread " + Thread.currentThread().getId() + ": " + Describe.describe(webdriver) + " -> " + webdriver);
        return this.markForAutoClose(this.addListeners(webdriver));
    }

    protected WebDriver addListeners(WebDriver webdriver) {
        if (this.listeners.isEmpty()) {
            return webdriver;
        }
        EventFiringWebDriver wrapper = new EventFiringWebDriver(webdriver);
        for (WebDriverEventListener listener : this.listeners) {
            log.info("Add listener to webdriver: " + listener);
            wrapper.register(listener);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WebDriver markForAutoClose(WebDriver webDriver) {
        this.ALL_WEB_DRIVERS_THREADS.add(Thread.currentThread());
        if (!this.cleanupThreadStarted.get()) {
            WebDriverThreadLocalContainer webDriverThreadLocalContainer = this;
            synchronized (webDriverThreadLocalContainer) {
                if (!this.cleanupThreadStarted.get()) {
                    new UnusedWebdriversCleanupThread().start();
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new WebdriversFinalCleanupThread(Thread.currentThread()));
        return webDriver;
    }

    protected class UnusedWebdriversCleanupThread
    extends Thread {
        public UnusedWebdriversCleanupThread() {
            this.setDaemon(true);
            this.setName("Webdrivers killer thread");
        }

        @Override
        public void run() {
            while (true) {
                WebDriverThreadLocalContainer.this.closeUnusedWebdrivers();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    protected class WebdriversFinalCleanupThread
    extends Thread {
        private final Thread thread;

        public WebdriversFinalCleanupThread(Thread thread) {
            this.thread = thread;
        }

        @Override
        public void run() {
            WebDriverThreadLocalContainer.this.closeWebDriver(this.thread);
        }
    }

    private static class CloseBrowser
    implements Runnable {
        private final WebDriver webdriver;
        private final SelenideProxyServer proxy;

        private CloseBrowser(WebDriver webdriver, SelenideProxyServer proxy) {
            this.webdriver = webdriver;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            try {
                log.info("Trying to close the browser " + Describe.describe(this.webdriver) + " ...");
                this.webdriver.quit();
            }
            catch (UnreachableBrowserException e) {
                log.log(Level.FINE, "Browser is unreachable", e);
            }
            catch (WebDriverException cannotCloseBrowser) {
                log.severe("Cannot close browser normally: " + Cleanup.of.webdriverExceptionMessage(cannotCloseBrowser));
            }
            finally {
                this.killBrowser(this.webdriver);
            }
            if (this.proxy != null) {
                log.info("Trying to shutdown " + this.proxy + " ...");
                this.proxy.shutdown();
            }
        }

        protected void killBrowser(WebDriver webdriver) {
            if (webdriver instanceof Killable) {
                try {
                    ((Killable)webdriver).kill();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to kill browser " + webdriver + ':', e);
                }
            }
        }
    }
}

