/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.lang.reflect.Field;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;

public class SelenidePageFactory
extends PageFactory {
    public static void initElements(FieldDecorator decorator, Object page) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            SelenidePageFactory.proxyFields(decorator, page, proxyIn);
        }
    }

    private static void proxyFields(FieldDecorator decorator, Object page, Class<?> proxyIn) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            Object value;
            if (SelenidePageFactory.isInitialized(page, field) || (value = decorator.decorate(page.getClass().getClassLoader(), field)) == null) continue;
            try {
                field.setAccessible(true);
                field.set(page, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean isInitialized(Object page, Field field) {
        try {
            field.setAccessible(true);
            return field.get(page) != null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

