/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.testng;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;
import org.testng.reporters.ExitCodeListener;

public class SoftAsserts
extends ExitCodeListener {
    public void onTestStart(ITestResult result) {
        this.addSelenideErrorListener(result);
    }

    public void onTestFailure(ITestResult result) {
        this.failIfErrors(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.failIfErrors(result);
    }

    public void onTestSuccess(ITestResult result) {
        this.failIfErrors(result);
    }

    public void onConfigurationFailure(ITestResult result) {
        this.failIfErrors(result);
    }

    void addSelenideErrorListener(ITestResult result) {
        if (this.shouldIntercept(result.getTestClass().getRealClass()) && this.shouldIntercept(result.getMethod().getConstructorOrMethod().getMethod())) {
            SelenideLogger.addListener("softAssert", new ErrorsCollector());
        }
    }

    boolean shouldIntercept(Class testClass) {
        Listeners listenersAnnotation = this.getListenersAnnotation(testClass);
        return listenersAnnotation != null && Arrays.asList(listenersAnnotation.value()).contains(SoftAsserts.class);
    }

    boolean shouldIntercept(Method testMethod) {
        if (testMethod == null) {
            return false;
        }
        Test annotation = testMethod.getAnnotation(Test.class);
        return annotation != null && Arrays.asList(annotation.expectedExceptions()).isEmpty();
    }

    Listeners getListenersAnnotation(Class testClass) {
        Listeners annotation = testClass.getAnnotation(Listeners.class);
        return annotation != null ? annotation : (testClass.getSuperclass() != null ? this.getListenersAnnotation(testClass.getSuperclass()) : null);
    }

    private void failIfErrors(ITestResult result) {
        ErrorsCollector errorsCollector = (ErrorsCollector)SelenideLogger.removeListener("softAssert");
        if (errorsCollector != null) {
            try {
                errorsCollector.failIfErrors(result.getTestClass().getName() + '.' + result.getName());
            }
            catch (AssertionError e) {
                result.setStatus(2);
                result.setThrowable((Throwable)((Object)e));
            }
        }
    }
}

