/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

class ChromeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(ChromeDriverFactory.class.getName());

    ChromeDriverFactory() {
    }

    @Override
    WebDriver create(Proxy proxy) {
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        ChromeOptions options = this.createChromeOptions();
        capabilities.setCapability("chromeOptions", (Object)options);
        return new ChromeDriver((Capabilities)capabilities);
    }

    @Override
    boolean supports() {
        return "chrome".equalsIgnoreCase(Configuration.browser);
    }

    ChromeOptions createChromeOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--no-sandbox"});
        if (Configuration.chromeSwitches != null) {
            options.addArguments(new String[]{Configuration.chromeSwitches});
        }
        options = this.transferChromeOptionsFromSystemProperties(options, "chromeoptions.");
        try {
            log.config("Chrome options:" + options.toJson().toString());
        }
        catch (IOException e) {
            log.warning("Error while reading from file:" + e.getMessage() + ". Ignoring it.");
            e.printStackTrace(System.err);
        }
        return options;
    }

    private ChromeOptions transferChromeOptionsFromSystemProperties(ChromeOptions currentChromeOptions, String prefix) {
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            if (capability.equals("args")) {
                List<String> args = Arrays.asList(value.split(","));
                currentChromeOptions.addArguments(args);
                continue;
            }
            log.warning(capability + "is ignored.Only so-called arguments (chromeoptions.args=<values comma separated>) are supported for the chromeoptions at the moment");
        }
        return currentChromeOptions;
    }
}

