/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

class FirefoxDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = Logger.getLogger(FirefoxDriverFactory.class.getName());

    FirefoxDriverFactory() {
    }

    @Override
    boolean supports() {
        return WebDriverRunner.isFirefox();
    }

    @Override
    WebDriver create(Proxy proxy) {
        return this.createFirefoxDriver(proxy);
    }

    private WebDriver createFirefoxDriver(Proxy proxy) {
        DesiredCapabilities capabilities = this.createFirefoxCapabilities(proxy);
        log.info("Firefox 48+ is currently not supported by Selenium Firefox driver. Use browser=marionette with geckodriver, when using it.");
        return new FirefoxDriver((Capabilities)capabilities);
    }

    DesiredCapabilities createFirefoxCapabilities(Proxy proxy) {
        FirefoxProfile myProfile = new FirefoxProfile();
        myProfile.setPreference("network.automatic-ntlm-auth.trusted-uris", "http://,https://");
        myProfile.setPreference("network.automatic-ntlm-auth.allow-non-fqdn", true);
        myProfile.setPreference("network.negotiate-auth.delegation-uris", "http://,https://");
        myProfile.setPreference("network.negotiate-auth.trusted-uris", "http://,https://");
        myProfile.setPreference("network.http.phishy-userpass-length", 255);
        myProfile.setPreference("security.csp.enable", false);
        DesiredCapabilities capabilities = this.createCommonCapabilities(proxy);
        myProfile = this.transferFirefoxProfileFromSystemProperties(myProfile, "firefoxprofile.");
        capabilities.setCapability("marionette", false);
        capabilities.setCapability("firefox_profile", (Object)myProfile);
        return capabilities;
    }

    private FirefoxProfile transferFirefoxProfileFromSystemProperties(FirefoxProfile currentFirefoxProfile, String prefix) {
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String capability = key.substring(prefix.length());
            String value = System.getProperties().getProperty(key);
            log.config("Use " + key + "=" + value);
            if (value.equals("true") || value.equals("false")) {
                currentFirefoxProfile.setPreference(capability, Boolean.valueOf(value).booleanValue());
                continue;
            }
            if (value.matches("^-?\\d+$")) {
                currentFirefoxProfile.setPreference(capability, Integer.parseInt(value));
                continue;
            }
            currentFirefoxProfile.setPreference(capability, value);
        }
        return currentFirefoxProfile;
    }
}

