/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.WebDriverRunner;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import org.apache.commons.lang3.StringUtils;

public class WebDriverBinaryManager {
    public void setupBinaryPath() {
        if (WebDriverRunner.isChrome() && !this.isSystemPropertySet("webdriver.chrome.driver")) {
            ChromeDriverManager.getInstance().setup();
        } else if (WebDriverRunner.isEdge() && !this.isSystemPropertySet("webdriver.edge.driver")) {
            EdgeDriverManager.getInstance().setup();
        } else if (WebDriverRunner.isIE() && !this.isSystemPropertySet("webdriver.ie.driver")) {
            InternetExplorerDriverManager.getInstance().setup();
        } else if (WebDriverRunner.isOpera() && !this.isSystemPropertySet("webdriver.opera.driver")) {
            OperaDriverManager.getInstance().setup();
        } else if (WebDriverRunner.isPhantomjs() && !this.isSystemPropertySet("phantomjs.binary.path")) {
            PhantomJsDriverManager.getInstance().setup();
        } else if (WebDriverRunner.isFirefox() && !this.isSystemPropertySet("webdriver.gecko.driver")) {
            FirefoxDriverManager.getInstance().setup();
        }
    }

    private boolean isSystemPropertySet(String key) {
        return StringUtils.isNotBlank((CharSequence)System.getProperty(key, ""));
    }
}

