/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.proxy.AuthenticationFilter;
import com.codeborne.selenide.proxy.BrowserMobProxyServerUnlimited;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.InetAddressResolver;
import com.codeborne.selenide.proxy.RequestSizeWatchdog;
import com.codeborne.selenide.proxy.ResponseSizeWatchdog;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.filters.RequestFilter;
import net.lightbody.bmp.filters.ResponseFilter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Proxy;

public class SelenideProxyServer {
    private final Config config;
    private final InetAddressResolver inetAddressResolver;
    private final Proxy outsideProxy;
    private final BrowserMobProxy proxy;
    private final Map<String, RequestFilter> requestFilters = new HashMap<String, RequestFilter>();
    private final Map<String, ResponseFilter> responseFilters = new HashMap<String, ResponseFilter>();
    private int port;

    public SelenideProxyServer(Config config, Proxy outsideProxy) {
        this(config, outsideProxy, new InetAddressResolver(), (BrowserMobProxy)new BrowserMobProxyServerUnlimited());
    }

    protected SelenideProxyServer(Config config, Proxy outsideProxy, InetAddressResolver inetAddressResolver, BrowserMobProxy proxy) {
        this.config = config;
        this.outsideProxy = outsideProxy;
        this.inetAddressResolver = inetAddressResolver;
        this.proxy = proxy;
    }

    public void start() {
        this.proxy.setTrustAllServers(true);
        if (this.outsideProxy != null) {
            this.proxy.setChainedProxy(SelenideProxyServer.getProxyAddress(this.outsideProxy));
        }
        this.addRequestFilter("authentication", new AuthenticationFilter());
        this.addRequestFilter("requestSizeWatchdog", new RequestSizeWatchdog());
        this.addResponseFilter("responseSizeWatchdog", new ResponseSizeWatchdog());
        this.addResponseFilter("download", new FileDownloadFilter(this.config.reportsFolder()));
        this.proxy.start(this.config.proxyPort());
        this.port = this.proxy.getPort();
    }

    public void addRequestFilter(String name, RequestFilter requestFilter) {
        if (this.isRequestFilterAdded(name)) {
            throw new IllegalArgumentException("Duplicate request filter: " + name);
        }
        this.proxy.addRequestFilter(requestFilter);
        this.requestFilters.put(name, requestFilter);
    }

    private boolean isRequestFilterAdded(String name) {
        return this.requestFilters.containsKey(name);
    }

    public void addResponseFilter(String name, ResponseFilter responseFilter) {
        if (this.responseFilters.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate response filter: " + name);
        }
        this.proxy.addResponseFilter(responseFilter);
        this.responseFilters.put(name, responseFilter);
    }

    static InetSocketAddress getProxyAddress(Proxy proxy) {
        String httpProxy = proxy.getHttpProxy();
        String host = httpProxy.replaceFirst("(.*):.*", "$1");
        String port = httpProxy.replaceFirst(".*:(.*)", "$1");
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    public Proxy createSeleniumProxy() {
        return StringUtils.isEmpty((CharSequence)this.config.proxyHost()) ? ClientUtil.createSeleniumProxy((BrowserMobProxy)this.proxy) : ClientUtil.createSeleniumProxy((BrowserMobProxy)this.proxy, (InetAddress)this.inetAddressResolver.getInetAddressByName(this.config.proxyHost()));
    }

    public void shutdown() {
        if (this.proxy.isStarted()) {
            try {
                this.proxy.abort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public BrowserMobProxy getProxy() {
        return this.proxy;
    }

    public String toString() {
        return String.format("Selenide proxy server :%s", this.port);
    }

    public <T extends RequestFilter> T requestFilter(String name) {
        return (T)this.requestFilters.get(name);
    }

    public <T extends ResponseFilter> T responseFilter(String name) {
        return (T)this.responseFilters.get(name);
    }
}

