/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.TimeoutException;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.HttpHelper;
import com.codeborne.selenide.impl.WebdriverCookieStore;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.openqa.selenium.WebElement;

public class DownloadFileWithHttpRequest {
    private static final Logger log = Logger.getLogger(DownloadFileWithHttpRequest.class.getName());
    protected boolean ignoreSelfSignedCerts = true;
    private HttpHelper httpHelper = new HttpHelper();

    public File download(Driver driver, WebElement element, long timeout) throws IOException {
        String fileToDownloadLocation = element.getAttribute("href");
        if (fileToDownloadLocation == null || fileToDownloadLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("The element does not have href attribute: " + Describe.describe(driver, element));
        }
        return this.download(driver, fileToDownloadLocation, timeout);
    }

    public File download(Driver driver, String relativeOrAbsoluteUrl, long timeout) throws IOException {
        String url = this.makeAbsoluteUrl(driver.config(), relativeOrAbsoluteUrl);
        HttpResponse response = this.executeHttpRequest(driver, url, timeout);
        if (response.getStatusLine().getStatusCode() >= 500) {
            throw new RuntimeException("Failed to download file " + url + ": " + response.getStatusLine());
        }
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new FileNotFoundException("Failed to download file " + url + ": " + response.getStatusLine());
        }
        File downloadedFile = this.prepareTargetFile(driver.config(), url, response);
        return this.saveFileContent(response, downloadedFile);
    }

    String makeAbsoluteUrl(Config config, String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.startsWith("/") ? config.baseUrl() + relativeOrAbsoluteUrl : relativeOrAbsoluteUrl;
    }

    protected HttpResponse executeHttpRequest(Driver driver, String fileToDownloadLocation, long timeout) throws IOException {
        CloseableHttpClient httpClient = this.ignoreSelfSignedCerts ? this.createTrustingHttpClient() : this.createDefaultHttpClient();
        HttpGet httpGet = new HttpGet(fileToDownloadLocation);
        this.configureHttpGet(httpGet, timeout);
        this.addHttpHeaders(driver, httpGet);
        try {
            return httpClient.execute((HttpUriRequest)httpGet, this.createHttpContext(driver));
        }
        catch (SocketTimeoutException timeoutException) {
            throw new TimeoutException("Failed to download " + fileToDownloadLocation + " in " + timeout + " ms.", timeoutException);
        }
    }

    protected void configureHttpGet(HttpGet httpGet, long timeout) {
        httpGet.setConfig(RequestConfig.custom().setConnectTimeout((int)timeout).setSocketTimeout((int)timeout).setConnectionRequestTimeout((int)timeout).setRedirectsEnabled(true).setCircularRedirectsAllowed(true).setMaxRedirects(20).setCookieSpec("standard").build());
    }

    protected CloseableHttpClient createDefaultHttpClient() {
        return HttpClients.createDefault();
    }

    protected CloseableHttpClient createTrustingHttpClient() throws IOException {
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            builder.setSSLContext(sslContext);
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            builder.setConnectionManager((HttpClientConnectionManager)connMgr);
            return builder.build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected HttpContext createHttpContext(Driver driver) {
        BasicHttpContext localContext = new BasicHttpContext();
        if (driver.hasWebDriverStarted()) {
            localContext.setAttribute("http.cookie-store", (Object)new WebdriverCookieStore(driver.getWebDriver()));
        }
        return localContext;
    }

    protected void addHttpHeaders(Driver driver, HttpGet httpGet) {
        if (driver.hasWebDriverStarted()) {
            httpGet.setHeader("User-Agent", driver.getUserAgent());
        }
    }

    protected File prepareTargetFile(Config config, String fileToDownloadLocation, HttpResponse response) {
        return new File(config.reportsFolder(), this.getFileName(fileToDownloadLocation, response));
    }

    protected String getFileName(String fileToDownloadLocation, HttpResponse response) {
        for (Header header : response.getAllHeaders()) {
            Optional<String> fileName = this.httpHelper.getFileNameFromContentDisposition(header.getName(), header.getValue());
            if (!fileName.isPresent()) continue;
            return fileName.get();
        }
        log.info("Cannot extract file name from http headers. Found headers: ");
        for (Header header : response.getAllHeaders()) {
            log.info(header.getName() + '=' + header.getValue());
        }
        String fullFileName = FilenameUtils.getName((String)fileToDownloadLocation);
        return fullFileName.contains("?") ? StringUtils.left((String)fullFileName, (int)fullFileName.indexOf("?")) : fullFileName;
    }

    protected File saveFileContent(HttpResponse response, File downloadedFile) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)downloadedFile);
        return downloadedFile;
    }

    private static class TrustAllStrategy
    implements TrustStrategy {
        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] arg0, String arg1) {
            return true;
        }
    }
}

