/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.impl.StaticConfig;
import com.codeborne.selenide.impl.UnusedWebdriversCleanupThread;
import com.codeborne.selenide.impl.WebDriverContainer;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class WebDriverThreadLocalContainer
implements WebDriverContainer {
    private final List<WebDriverEventListener> listeners = new ArrayList<WebDriverEventListener>();
    private final Collection<Thread> allWebDriverThreads = new ConcurrentLinkedQueue<Thread>();
    private final Map<Long, SelenideDriver> threadWebDriver = new ConcurrentHashMap<Long, SelenideDriver>(4);
    private Proxy userProvidedProxy;
    private final AtomicBoolean cleanupThreadStarted = new AtomicBoolean(false);

    @Override
    public void addListener(WebDriverEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void setWebDriver(WebDriver webDriver) {
        SelenideDriver previous = this.threadWebDriver.get(Thread.currentThread().getId());
        if (previous != null) {
            previous.close();
        }
        this.threadWebDriver.put(Thread.currentThread().getId(), new SelenideDriver(new StaticConfig(), webDriver));
    }

    @Override
    public void setProxy(Proxy userProvidedProxy) {
        this.userProvidedProxy = userProvidedProxy;
    }

    @Override
    public boolean hasWebDriverStarted() {
        SelenideDriver selenideDriver = this.threadWebDriver.get(Thread.currentThread().getId());
        return selenideDriver != null && selenideDriver.hasWebDriverStarted();
    }

    @Override
    public SelenideDriver getSelenideDriver() {
        return this.threadWebDriver.computeIfAbsent(Thread.currentThread().getId(), threadId -> this.markForAutoClose(Thread.currentThread(), new SelenideDriver(new StaticConfig(), this.userProvidedProxy, this.listeners)));
    }

    @Override
    public WebDriver getWebDriver() {
        return this.getSelenideDriver().getWebDriver();
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        return this.getSelenideDriver().getAndCheckWebDriver();
    }

    @Override
    public SelenideProxyServer getProxyServer() {
        return this.getSelenideDriver().getProxy();
    }

    @Override
    public void closeWebDriver() {
        SelenideDriver driver = this.threadWebDriver.remove(Thread.currentThread().getId());
        if (driver != null) {
            driver.close();
        }
    }

    @Override
    public void clearBrowserCache() {
        if (this.hasWebDriverStarted()) {
            this.getSelenideDriver().clearCookies();
        }
    }

    @Override
    public String getPageSource() {
        return this.getSelenideDriver().source();
    }

    @Override
    public String getCurrentUrl() {
        return this.getSelenideDriver().url();
    }

    @Override
    public String getCurrentFrameUrl() {
        return this.getSelenideDriver().getCurrentFrameUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelenideDriver markForAutoClose(Thread thread, SelenideDriver selenideDriver) {
        this.allWebDriverThreads.add(thread);
        if (!this.cleanupThreadStarted.get()) {
            WebDriverThreadLocalContainer webDriverThreadLocalContainer = this;
            synchronized (webDriverThreadLocalContainer) {
                if (!this.cleanupThreadStarted.get()) {
                    new UnusedWebdriversCleanupThread(this.allWebDriverThreads, this.threadWebDriver).start();
                    this.cleanupThreadStarted.set(true);
                }
            }
        }
        return selenideDriver;
    }
}

