/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class WebDriverBinaryManager {
    private static final Logger log = Logger.getLogger(WebDriverBinaryManager.class.getName());

    public void setupBinaryPath(Browser browser) {
        if (browser.isChrome()) {
            this.setupChrome();
        }
        if (browser.isEdge()) {
            this.setupEdge();
        }
        if (browser.isIE()) {
            this.setupIE();
        }
        if (browser.isOpera()) {
            this.setupOpera();
        }
        if (browser.isPhantomjs()) {
            this.setupPhantomjs();
        }
        if (browser.isFirefox()) {
            this.setupFirefox();
        }
    }

    private void setupChrome() {
        this.cacheMeIfYouCan("webdriver.chrome.driver", () -> WebDriverManager.chromedriver().setup());
    }

    private void setupEdge() {
        this.cacheMeIfYouCan("webdriver.edge.driver", () -> WebDriverManager.edgedriver().setup());
    }

    private void setupIE() {
        this.cacheMeIfYouCan("webdriver.ie.driver", () -> WebDriverManager.iedriver().setup());
    }

    private void setupOpera() {
        this.cacheMeIfYouCan("webdriver.opera.driver", () -> WebDriverManager.operadriver().setup());
    }

    private void setupPhantomjs() {
        this.cacheMeIfYouCan("phantomjs.binary.path", () -> WebDriverManager.phantomjs().setup());
    }

    private void setupFirefox() {
        this.cacheMeIfYouCan("webdriver.gecko.driver", () -> WebDriverManager.firefoxdriver().setup());
    }

    private void cacheMeIfYouCan(String systemPropertyName, Runnable webdriverSetup) {
        if (this.webdriverIsAlreadyInitialized(systemPropertyName)) {
            log.log(Level.FINE, "Skip: webdriver is already initialized: " + System.getProperty(systemPropertyName));
            return;
        }
        File lastCheckIndicator = new File(WebDriverManager.config().getTargetPath(), this.lastModifiedFileName(systemPropertyName));
        boolean canUseCachedWebdriver = lastCheckIndicator.exists() && this.hasRecentlyCheckedForUpdates(lastCheckIndicator);
        log.log(Level.FINE, "lastCheckIndicator=" + lastCheckIndicator.getAbsolutePath() + ", exists=" + lastCheckIndicator.exists() + ", lastModified=" + new Date(lastCheckIndicator.lastModified()) + ", now=" + new Date() + ", diff: " + (System.currentTimeMillis() - lastCheckIndicator.lastModified()) + " ms.");
        if (canUseCachedWebdriver) {
            log.log(Level.FINE, "Can use cache");
            WebDriverManager.config().setForceCache(true);
        } else {
            log.log(Level.FINE, "Cannot use cache");
        }
        webdriverSetup.run();
        if (!canUseCachedWebdriver) {
            long ts = System.currentTimeMillis();
            log.log(Level.FINE, "Mark as recently checked: " + lastCheckIndicator.getAbsolutePath() + ", ts=" + ts + ", now=" + new Date(ts));
            this.markAsRecentlyChecked(lastCheckIndicator);
        } else {
            long ts = System.currentTimeMillis();
            log.log(Level.FINE, "Not marking as recently checked: " + lastCheckIndicator.getAbsolutePath() + ", ts=" + ts + ", now=" + new Date(ts));
        }
    }

    private boolean webdriverIsAlreadyInitialized(String systemPropertyName) {
        return StringUtils.isNotBlank((CharSequence)System.getProperty(systemPropertyName, ""));
    }

    private String lastModifiedFileName(String systemPropertyName) {
        return systemPropertyName + '.' + WebDriverManager.config().getOs().toLowerCase() + WebDriverManager.config().getArchitecture() + ".timestamp";
    }

    private boolean hasRecentlyCheckedForUpdates(File lastCheckIndicator) {
        return System.currentTimeMillis() - lastCheckIndicator.lastModified() < TimeUnit.HOURS.toMillis(4L);
    }

    private void markAsRecentlyChecked(File lastCheckIndicator) {
        block5: {
            if (!lastCheckIndicator.exists()) {
                try {
                    if (!lastCheckIndicator.createNewFile()) {
                        throw new RuntimeException("Failed to create " + lastCheckIndicator.getAbsolutePath());
                    }
                    break block5;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create " + lastCheckIndicator.getAbsolutePath(), e);
                }
            }
            if (!lastCheckIndicator.setLastModified(System.currentTimeMillis())) {
                throw new RuntimeException("Failed to touch " + lastCheckIndicator.getAbsolutePath());
            }
        }
    }
}

