/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.WebDriverRunner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class Selenide {
    public static void open(String relativeOrAbsoluteUrl) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl);
    }

    public static void open(URL absoluteUrl) {
        WebDriverRunner.getSelenideDriver().open(absoluteUrl);
    }

    public static void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, domain, login, password);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, String login, String password) {
        Credentials credentials = new Credentials(login, password);
        Selenide.open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public static void open(URL absoluteUrl, String domain, String login, String password) {
        WebDriverRunner.getSelenideDriver().open(absoluteUrl, domain, login, password);
    }

    public static void updateHash(String hash) {
        WebDriverRunner.getSelenideDriver().updateHash(hash);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(absoluteUrl, pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(relativeOrAbsoluteUrl, domain, login, password, pageObjectClassClass);
    }

    public static <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        return WebDriverRunner.getSelenideDriver().open(absoluteUrl, domain, login, password, pageObjectClassClass);
    }

    public static void close() {
        WebDriverRunner.closeWebDriver();
    }

    public static void refresh() {
        WebDriverRunner.getSelenideDriver().refresh();
    }

    public static void back() {
        WebDriverRunner.getSelenideDriver().back();
    }

    public static void forward() {
        WebDriverRunner.getSelenideDriver().forward();
    }

    public static String title() {
        return WebDriverRunner.getSelenideDriver().title();
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static String screenshot(String fileName) {
        return Screenshots.takeScreenShot(fileName);
    }

    public static SelenideElement $(WebElement webElement) {
        return WebDriverRunner.getSelenideDriver().$(webElement);
    }

    public static SelenideElement $(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().find(cssSelector);
    }

    public static SelenideElement $x(String xpathExpression) {
        return WebDriverRunner.getSelenideDriver().$x(xpathExpression);
    }

    public static SelenideElement $(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().find(seleniumSelector);
    }

    public static SelenideElement $(By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().find(seleniumSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(cssSelector);
    }

    public static SelenideElement $(String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(cssSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, String cssSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(cssSelector, index);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(seleniumSelector);
    }

    @Deprecated
    public static SelenideElement $(WebElement parent, By seleniumSelector, int index) {
        return WebDriverRunner.getSelenideDriver().$(parent).find(seleniumSelector, index);
    }

    public static ElementsCollection $$(Collection<? extends WebElement> elements) {
        return WebDriverRunner.getSelenideDriver().$$(elements);
    }

    public static ElementsCollection $$(String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$$(cssSelector);
    }

    public static ElementsCollection $$x(String xpathExpression) {
        return WebDriverRunner.getSelenideDriver().$$x(xpathExpression);
    }

    public static ElementsCollection $$(By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$$(seleniumSelector);
    }

    @Deprecated
    public static ElementsCollection $$(WebElement parent, String cssSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).findAll(cssSelector);
    }

    @Deprecated
    public static ElementsCollection $$(WebElement parent, By seleniumSelector) {
        return WebDriverRunner.getSelenideDriver().$(parent).findAll(seleniumSelector);
    }

    public static SelenideElement getElement(By criteria) {
        return WebDriverRunner.getSelenideDriver().find(criteria);
    }

    public static SelenideElement getElement(By criteria, int index) {
        return WebDriverRunner.getSelenideDriver().find(criteria, index);
    }

    public static ElementsCollection getElements(By criteria) {
        return WebDriverRunner.getSelenideDriver().findAll(criteria);
    }

    public static <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return WebDriverRunner.getSelenideDriver().executeJavaScript(jsCode, arguments);
    }

    public static SelenideElement getSelectedRadio(By radioField) {
        return WebDriverRunner.getSelenideDriver().getSelectedRadio(radioField);
    }

    public static String confirm() {
        return WebDriverRunner.getSelenideDriver().modal().confirm();
    }

    public static String confirm(String expectedDialogText) {
        return WebDriverRunner.getSelenideDriver().modal().confirm(expectedDialogText);
    }

    public static String prompt() {
        return WebDriverRunner.getSelenideDriver().modal().prompt();
    }

    public static String prompt(String inputText) {
        return WebDriverRunner.getSelenideDriver().modal().prompt(inputText);
    }

    public static String prompt(String expectedDialogText, String inputText) {
        return WebDriverRunner.getSelenideDriver().modal().prompt(expectedDialogText, inputText);
    }

    public static String dismiss() {
        return WebDriverRunner.getSelenideDriver().modal().dismiss();
    }

    public static String dismiss(String expectedDialogText) {
        return WebDriverRunner.getSelenideDriver().modal().dismiss(expectedDialogText);
    }

    public static SelenideTargetLocator switchTo() {
        return WebDriverRunner.getSelenideDriver().driver().switchTo();
    }

    public static WebElement getFocusedElement() {
        return WebDriverRunner.getSelenideDriver().getFocusedElement();
    }

    public static <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return WebDriverRunner.getSelenideDriver().page(pageObjectClass);
    }

    public static <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return WebDriverRunner.getSelenideDriver().page(pageObject);
    }

    public static SelenideWait Wait() {
        return WebDriverRunner.getSelenideDriver().Wait();
    }

    public static Actions actions() {
        return WebDriverRunner.getSelenideDriver().driver().actions();
    }

    public static void zoom(double factor) {
        WebDriverRunner.getSelenideDriver().zoom(factor);
    }

    public static List<String> getWebDriverLogs(String logType) {
        return WebDriverRunner.getSelenideDriver().getWebDriverLogs().logs(logType);
    }

    public static List<String> getWebDriverLogs(String logType, Level logLevel) {
        return WebDriverRunner.getSelenideDriver().getWebDriverLogs().logs(logType, logLevel);
    }

    public static void clearBrowserCookies() {
        WebDriverRunner.getSelenideDriver().clearCookies();
    }

    public static void clearBrowserLocalStorage() {
        WebDriverRunner.getSelenideDriver().clearBrowserLocalStorage();
    }

    public static String getUserAgent() {
        return WebDriverRunner.getSelenideDriver().driver().getUserAgent();
    }

    public static boolean atBottom() {
        return WebDriverRunner.getSelenideDriver().atBottom();
    }

    public static File download(String url) throws IOException {
        return WebDriverRunner.getSelenideDriver().download(url);
    }

    public static File download(String url, long timeoutMs) throws IOException {
        return WebDriverRunner.getSelenideDriver().download(url, timeoutMs);
    }
}

