/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.TextsMismatch;
import com.codeborne.selenide.impl.Html;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.WebElement;

public class ExactTexts
extends CollectionCondition {
    protected final List<String> expectedTexts;

    public ExactTexts(String ... expectedTexts) {
        this(Arrays.asList(expectedTexts));
    }

    public ExactTexts(List<String> expectedTexts) {
        if (expectedTexts.isEmpty()) {
            throw new IllegalArgumentException("No expected texts given");
        }
        this.expectedTexts = Collections.unmodifiableList(expectedTexts);
    }

    public boolean apply(List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return false;
        }
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            WebElement element = elements.get(i);
            String expectedText = this.expectedTexts.get(i);
            if (Html.text.equals(element.getText(), expectedText)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void fail(WebElementsCollection collection, List<WebElement> elements, Exception lastError, long timeoutMs) {
        if (elements == null || elements.isEmpty()) {
            ElementNotFound elementNotFound = new ElementNotFound(collection, this.expectedTexts, (Throwable)lastError);
            elementNotFound.timeoutMs = timeoutMs;
            throw elementNotFound;
        }
        throw new TextsMismatch(collection, ElementsCollection.texts(elements), this.expectedTexts, this.explanation, timeoutMs);
    }

    public String toString() {
        return "Exact texts " + this.expectedTexts;
    }
}

