/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.drivercommands.CloseDriverCommand;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import org.openqa.selenium.WebDriver;

public class WebDriverWrapper
implements Driver {
    private final WebDriver webDriver;
    private final Config config;

    public WebDriverWrapper(Config config, WebDriver webDriver) {
        this.config = config;
        this.webDriver = webDriver;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public Browser browser() {
        return new Browser(this.config.browser(), this.config.headless());
    }

    @Override
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    @Override
    public SelenideProxyServer getProxy() {
        return null;
    }

    @Override
    public WebDriver getAndCheckWebDriver() {
        return this.webDriver;
    }

    @Override
    public void close() {
        if (!this.config().holdBrowserOpen()) {
            new CloseDriverCommand(this.webDriver, null).run();
        }
    }
}

