/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ErrorMessages;
import com.codeborne.selenide.ex.UIAssertionError;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ScreenShooterExtension
implements BeforeAllCallback,
AfterEachCallback,
AfterAllCallback {
    private static final Logger log = Logger.getLogger(ScreenShooterExtension.class.getName());
    private final boolean captureSuccessfulTests;

    public ScreenShooterExtension() {
        this(false);
    }

    public ScreenShooterExtension(boolean captureSuccessfulTests) {
        this.captureSuccessfulTests = captureSuccessfulTests;
    }

    public ScreenShooterExtension to(String folderWithScreenshots) {
        Configuration.reportsFolder = folderWithScreenshots;
        return this;
    }

    public void beforeAll(ExtensionContext context) {
        Optional testClass = context.getTestClass();
        String className = testClass.isPresent() ? ((Class)testClass.get()).getName() : "EmptyClass";
        Optional testMethod = context.getTestMethod();
        String methodName = testMethod.isPresent() ? ((Method)testMethod.get()).getName() : "emptyMethod";
        Screenshots.startContext(className, methodName);
    }

    public void afterEach(ExtensionContext context) {
        if (this.captureSuccessfulTests) {
            log.info(ErrorMessages.screenshot(WebDriverRunner.driver()));
        } else {
            Optional executionException = context.getExecutionException();
            if (executionException.isPresent() && executionException.get() instanceof UIAssertionError) {
                log.info(ErrorMessages.screenshot(WebDriverRunner.driver()));
            }
        }
    }

    public void afterAll(ExtensionContext context) {
        Screenshots.finishContext();
    }
}

