/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.selector.ByShadow;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.Quotes;

public class Selectors {
    private static final String NORMALIZE_SPACE_XPATH = "normalize-space(translate(string(.), '\t\n\r\u00a0', '    '))";

    public static By withText(String elementText) {
        return new WithText(elementText);
    }

    public static By byText(String elementText) {
        return new ByText(elementText);
    }

    public static By byAttribute(String attributeName, String attributeValue) {
        String escapedAttributeValue = attributeValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
        return By.cssSelector((String)String.format("[%s=\"%s\"]", attributeName, escapedAttributeValue));
    }

    public static By shadowCss(String target, String shadowHost, String ... innerShadowHosts) {
        return ByShadow.cssSelector(target, shadowHost, innerShadowHosts);
    }

    public static By by(String attributeName, String attributeValue) {
        return Selectors.byAttribute(attributeName, attributeValue);
    }

    public static By byTitle(String title) {
        return Selectors.byAttribute("title", title);
    }

    public static By byValue(String value) {
        return Selectors.byAttribute("value", value);
    }

    public static By byName(String name) {
        return By.name((String)name);
    }

    public static By byXpath(String xpath) {
        return By.xpath((String)xpath);
    }

    public static By byLinkText(String linkText) {
        return By.linkText((String)linkText);
    }

    public static By byPartialLinkText(String partialLinkText) {
        return By.partialLinkText((String)partialLinkText);
    }

    public static By byId(String id) {
        return By.id((String)id);
    }

    public static By byCssSelector(String css) {
        return By.cssSelector((String)css);
    }

    public static By byClassName(String className) {
        return By.className((String)className);
    }

    public static class WithText
    extends By.ByXPath {
        protected final String elementText;

        public WithText(String elementText) {
            super(".//*/text()[contains(normalize-space(translate(string(.), '\t\n\r\u00a0', '    ')), " + Quotes.escape((String)elementText) + ")]/parent::*");
            this.elementText = elementText;
        }

        public String toString() {
            return "with text: " + this.elementText;
        }

        String getXPath() {
            return super.toString().replace("By.xpath: ", "");
        }
    }

    public static class ByText
    extends By.ByXPath {
        protected final String elementText;

        public ByText(String elementText) {
            super(".//*/text()[normalize-space(translate(string(.), '\t\n\r\u00a0', '    ')) = " + Quotes.escape((String)elementText) + "]/parent::*");
            this.elementText = elementText;
        }

        public String toString() {
            return "by text: " + this.elementText;
        }

        String getXPath() {
            return super.toString().replace("By.xpath: ", "");
        }
    }
}

