/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class PseudoElementPropertyWithValue
extends Condition {
    static final String JS_CODE = "return window.getComputedStyle(arguments[0], arguments[1]).getPropertyValue(arguments[2]);";
    private final String pseudoElementName;
    private final String propertyName;
    private final String expectedPropertyValue;

    public PseudoElementPropertyWithValue(String pseudoElementName, String propertyName, String expectedPropertyValue) {
        super("pseudo-element");
        this.pseudoElementName = pseudoElementName;
        this.propertyName = propertyName;
        this.expectedPropertyValue = expectedPropertyValue;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return StringUtils.defaultString((String)this.expectedPropertyValue).equalsIgnoreCase(this.getPseudoElementPropertyValue(driver, element));
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return String.format("%s {%s: %s;}", this.pseudoElementName, this.propertyName, this.getPseudoElementPropertyValue(driver, element));
    }

    @Override
    public String toString() {
        return String.format("%s %s {%s: %s;}", this.getName(), this.pseudoElementName, this.propertyName, this.expectedPropertyValue);
    }

    private String getPseudoElementPropertyValue(Driver driver, WebElement element) {
        String propertyValue = (String)driver.executeJavaScript(JS_CODE, element, this.pseudoElementName, this.propertyName);
        return propertyValue == null ? "" : propertyValue;
    }
}

