/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ex.TimeoutException;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.HttpHelper;
import com.codeborne.selenide.impl.WebdriverCookieStore;
import com.codeborne.selenide.proxy.DownloadedFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFileWithHttpRequest {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithHttpRequest.class);
    protected boolean ignoreSelfSignedCerts = true;
    private final Downloader downloader;
    private HttpHelper httpHelper = new HttpHelper();

    public DownloadFileWithHttpRequest() {
        this(new Downloader());
    }

    DownloadFileWithHttpRequest(Downloader downloader) {
        this.downloader = downloader;
    }

    public File download(Driver driver, WebElement element, long timeout, FileFilter fileFilter) throws IOException {
        String fileToDownloadLocation = element.getAttribute("href");
        if (fileToDownloadLocation == null || fileToDownloadLocation.trim().isEmpty()) {
            throw new IllegalArgumentException("The element does not have href attribute: " + Describe.describe(driver, element));
        }
        return this.download(driver, fileToDownloadLocation, timeout, fileFilter);
    }

    public File download(Driver driver, String relativeOrAbsoluteUrl, long timeout, FileFilter fileFilter) throws IOException {
        String url = this.makeAbsoluteUrl(driver.config(), relativeOrAbsoluteUrl);
        HttpResponse response = this.executeHttpRequest(driver, url, timeout);
        if (response.getStatusLine().getStatusCode() >= 500) {
            throw new RuntimeException("Failed to download file " + url + ": " + response.getStatusLine());
        }
        if (response.getStatusLine().getStatusCode() >= 400) {
            throw new FileNotFoundException("Failed to download file " + url + ": " + response.getStatusLine());
        }
        String fileName = this.getFileName(url, response);
        File downloadedFile = this.downloader.prepareTargetFile(driver.config(), fileName);
        this.saveContentToFile(response, downloadedFile);
        if (!fileFilter.match(new DownloadedFile(downloadedFile, Collections.emptyMap()))) {
            throw new FileNotFoundException(String.format("Failed to download file from %s in %d ms.%s %n; actually downloaded: %s", relativeOrAbsoluteUrl, timeout, fileFilter.description(), downloadedFile.getAbsolutePath()));
        }
        return downloadedFile;
    }

    String makeAbsoluteUrl(Config config, String relativeOrAbsoluteUrl) {
        return relativeOrAbsoluteUrl.startsWith("/") ? config.baseUrl() + relativeOrAbsoluteUrl : relativeOrAbsoluteUrl;
    }

    protected HttpResponse executeHttpRequest(Driver driver, String fileToDownloadLocation, long timeout) throws IOException {
        CloseableHttpClient httpClient = this.ignoreSelfSignedCerts ? this.createTrustingHttpClient() : this.createDefaultHttpClient();
        HttpGet httpGet = new HttpGet(fileToDownloadLocation);
        this.configureHttpGet(httpGet, timeout);
        this.addHttpHeaders(driver, httpGet);
        try {
            return httpClient.execute((HttpUriRequest)httpGet, this.createHttpContext(driver));
        }
        catch (SocketTimeoutException timeoutException) {
            throw new TimeoutException("Failed to download " + fileToDownloadLocation + " in " + timeout + " ms.", timeoutException);
        }
    }

    protected void configureHttpGet(HttpGet httpGet, long timeout) {
        httpGet.setConfig(RequestConfig.custom().setConnectTimeout((int)timeout).setSocketTimeout((int)timeout).setConnectionRequestTimeout((int)timeout).setRedirectsEnabled(true).setCircularRedirectsAllowed(true).setMaxRedirects(20).setCookieSpec("standard").build());
    }

    protected CloseableHttpClient createDefaultHttpClient() {
        return HttpClients.createDefault();
    }

    protected CloseableHttpClient createTrustingHttpClient() throws IOException {
        try {
            HttpClientBuilder builder = HttpClientBuilder.create();
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            builder.setSSLContext(sslContext);
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            builder.setConnectionManager((HttpClientConnectionManager)connMgr);
            return builder.build();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected HttpContext createHttpContext(Driver driver) {
        BasicHttpContext localContext = new BasicHttpContext();
        if (driver.hasWebDriverStarted()) {
            localContext.setAttribute("http.cookie-store", (Object)new WebdriverCookieStore(driver.getWebDriver()));
        }
        return localContext;
    }

    protected void addHttpHeaders(Driver driver, HttpGet httpGet) {
        if (driver.hasWebDriverStarted()) {
            httpGet.setHeader("User-Agent", driver.getUserAgent());
        }
    }

    protected String getFileName(String fileToDownloadLocation, HttpResponse response) {
        for (Header header : response.getAllHeaders()) {
            Optional<String> fileName = this.httpHelper.getFileNameFromContentDisposition(header.getName(), header.getValue());
            if (!fileName.isPresent()) continue;
            return fileName.get();
        }
        log.info("Cannot extract file name from http headers. Found headers: ");
        for (Header header : response.getAllHeaders()) {
            log.info("{}={}", (Object)header.getName(), (Object)header.getValue());
        }
        String fileNameFromUrl = this.httpHelper.getFileName(fileToDownloadLocation);
        return StringUtils.isNotBlank((CharSequence)fileNameFromUrl) ? fileNameFromUrl : this.downloader.randomFileName();
    }

    protected void saveContentToFile(HttpResponse response, File downloadedFile) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)downloadedFile);
    }

    private static class TrustAllStrategy
    implements TrustStrategy {
        private TrustAllStrategy() {
        }

        public boolean isTrusted(X509Certificate[] arg0, String arg1) {
            return true;
        }
    }
}

