/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.HttpHelper;
import com.codeborne.selenide.proxy.DownloadedFile;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadFilter
implements ResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadFilter.class);
    private final Config config;
    private final Downloader downloader;
    private HttpHelper httpHelper = new HttpHelper();
    private boolean active;
    private final List<DownloadedFile> downloadedFiles = new CopyOnWriteArrayList<DownloadedFile>();
    private final List<Response> responses = new CopyOnWriteArrayList<Response>();

    public FileDownloadFilter(Config config) {
        this(config, new Downloader());
    }

    FileDownloadFilter(Config config, Downloader downloader) {
        this.config = config;
        this.downloader = downloader;
    }

    public void activate() {
        this.reset();
        this.active = true;
    }

    public void reset() {
        this.downloadedFiles.clear();
        this.responses.clear();
    }

    public void deactivate() {
        this.active = false;
    }

    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (!this.active) {
            return;
        }
        Response r = new Response(messageInfo.getUrl(), response.status().code(), response.status().reasonPhrase(), this.toMap(response.headers()), contents.getContentType(), contents.getTextContents());
        this.responses.add(r);
        if (response.status().code() < 200 || response.status().code() >= 300) {
            return;
        }
        String fileName = this.getFileName(r);
        if (fileName == null) {
            return;
        }
        File file = this.downloader.prepareTargetFile(this.config, fileName);
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])contents.getBinaryContents());
            this.downloadedFiles.add(new DownloadedFile(file, r.headers));
        }
        catch (IOException e) {
            log.error("Failed to save downloaded file to {} for url {}", new Object[]{file.getAbsolutePath(), messageInfo.getUrl(), e});
        }
    }

    private Map<String, String> toMap(HttpHeaders headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry header : headers) {
            map.put(((String)header.getKey()).toLowerCase(), (String)header.getValue());
        }
        return map;
    }

    public List<DownloadedFile> getDownloadedFiles() {
        return this.downloadedFiles;
    }

    public List<DownloadedFile> getDownloadedFiles(FileFilter fileFilter) {
        return this.downloadedFiles.stream().filter(fileFilter::match).collect(Collectors.toList());
    }

    private String getFileName(Response response) {
        return this.httpHelper.getFileNameFromContentDisposition(response.headers).orElseGet(() -> {
            log.info("Cannot extract file name from http headers. Found headers: ");
            for (Map.Entry header : response.headers.entrySet()) {
                log.info("{}={}", header.getKey(), header.getValue());
            }
            String fileNameFromUrl = this.httpHelper.getFileName(response.url);
            return StringUtils.isNotBlank((CharSequence)fileNameFromUrl) ? fileNameFromUrl : this.downloader.randomFileName();
        });
    }

    public String responsesAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Intercepted ").append(this.responses.size()).append(" responses:\n");
        int i = 0;
        for (Response response : this.responses) {
            sb.append("  #").append(++i).append("  ").append(response).append("\n");
        }
        return sb.toString();
    }

    public String downloadedFilesAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Downloaded ").append(this.downloadedFiles.size()).append(" files:\n");
        int i = 0;
        for (DownloadedFile file : this.downloadedFiles) {
            sb.append("  #").append(++i).append("  ").append(file.getFile().getAbsolutePath()).append("\n");
        }
        return sb.toString();
    }

    private static class Response {
        private final String url;
        private final int code;
        private final String reasonPhrase;
        private final String contentType;
        private final Map<String, String> headers;
        private final String content;

        private Response(String url, int code, String reasonPhrase, Map<String, String> headers, String contentType, String content) {
            this.url = url;
            this.code = code;
            this.reasonPhrase = reasonPhrase;
            this.headers = headers;
            this.contentType = contentType;
            this.content = content;
        }

        public String toString() {
            return this.url + " -> " + this.code + " \"" + this.reasonPhrase + "\" " + this.headers + " " + this.contentType + "  (" + this.content.length() + " bytes)";
        }
    }
}

