/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChromeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverFactory.class);

    ChromeDriverFactory() {
    }

    @Override
    WebDriver create(Config config, Proxy proxy) {
        ChromeOptions options = this.createChromeOptions(config, proxy);
        return new ChromeDriver(options);
    }

    @Override
    boolean supports(Config config, Browser browser) {
        return browser.isChrome();
    }

    ChromeOptions createChromeOptions(Config config, Proxy proxy) {
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(config.headless());
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            options.setBinary(config.browserBinary());
        }
        options.setExperimentalOption("excludeSwitches", (Object)new String[]{"enable-automation"});
        options.addArguments(new String[]{"--proxy-bypass-list=<-loopback>"});
        options.merge((Capabilities)this.createCommonCapabilities(config, proxy));
        this.transferChromeOptionsFromSystemProperties(config, options);
        log.debug("Chrome options: {}", (Object)options.toString());
        return options;
    }

    private void transferChromeOptionsFromSystemProperties(Config config, ChromeOptions currentChromeOptions) {
        Map<String, Object> prefs;
        if (System.getProperty("chromeoptions.args") != null) {
            Stream<String> params = Arrays.stream(this.parseCSVhandlingQuotes(System.getProperty("chromeoptions.args")));
            List args = params.map(s -> s.replace("\"", "")).collect(Collectors.toList());
            currentChromeOptions.addArguments(args);
        }
        HashMap<String, Object> chromePreferences = new HashMap<String, Object>();
        chromePreferences.put("download.default_directory", new File(config.downloadsFolder()).getAbsolutePath());
        if (System.getProperty("chromeoptions.prefs") != null) {
            prefs = this.parsePreferencesFromString(System.getProperty("chromeoptions.prefs"));
            chromePreferences.putAll(prefs);
        }
        currentChromeOptions.setExperimentalOption("prefs", chromePreferences);
        if (System.getProperty("chromeoptions.mobileEmulation") != null) {
            prefs = this.parsePreferencesFromString(System.getProperty("chromeoptions.mobileEmulation"));
            currentChromeOptions.setExperimentalOption("mobileEmulation", prefs);
        }
    }

    private Map<String, Object> parsePreferencesFromString(String preferencesString) {
        String[] allPrefs;
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        for (String pref : allPrefs = this.parseCSVhandlingQuotes(preferencesString)) {
            String[] keyValue = pref.replace("\"", "").split("=");
            if (keyValue.length == 1) {
                log.warn("Missing '=' sign while parsing <key=value> pairs from {}. Key '{}' is ignored.", (Object)preferencesString, (Object)keyValue[0]);
                continue;
            }
            if (keyValue.length > 2) {
                log.warn("More than one '=' sign while parsing <key=value> pairs from {}. Key '{}' is ignored.", (Object)preferencesString, (Object)keyValue[0]);
                continue;
            }
            Object prefValue = this.convertStringToNearestObjectType(keyValue[1]);
            prefs.put(keyValue[0], prefValue);
        }
        return prefs;
    }

    private String[] parseCSVhandlingQuotes(String csvString) {
        return csvString.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    }

    private Object convertStringToNearestObjectType(String value) {
        switch (value) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        if (NumberUtils.isParsable((String)value)) {
            return Integer.parseInt(value);
        }
        return value;
    }
}

