/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Click;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.util.List;
import org.openqa.selenium.WebElement;

public class SelectRadio
implements Command<SelenideElement> {
    private final Click click;

    public SelectRadio() {
        this.click = new Click();
    }

    public SelectRadio(Click click) {
        this.click = click;
    }

    @Override
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        String value = (String)args[0];
        List<WebElement> matchingRadioButtons = locator.findAll();
        for (WebElement radio : matchingRadioButtons) {
            if (!value.equals(radio.getAttribute("value"))) continue;
            if (radio.getAttribute("readonly") != null) {
                throw new InvalidStateException(locator.driver(), "Cannot select readonly radio button");
            }
            this.click.click(locator.driver(), radio);
            return WebElementWrapper.wrap(locator.driver(), radio);
        }
        throw new ElementNotFound(locator.driver(), locator.getSearchCriteria(), Condition.value(value));
    }
}

