/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.selector;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;

public class ByShadow {
    public static By cssSelector(String target, String shadowHost, String ... innerShadowHosts) {
        return new ByShadowCss(target, shadowHost, innerShadowHosts);
    }

    public static class ByShadowCss
    extends By
    implements Serializable {
        private static final long serialVersionUID = -1230258723099459239L;
        private final String shadowHost;
        private final String[] innerShadowHosts;
        private final String target;

        ByShadowCss(String target, String shadowHost, String ... innerShadowHosts) {
            if (shadowHost == null || target == null) {
                throw new IllegalArgumentException("Cannot find elements when the selector is null");
            }
            this.shadowHost = shadowHost;
            this.innerShadowHosts = innerShadowHosts;
            this.target = target;
        }

        public WebElement findElement(SearchContext context) {
            WebElement host = context.findElement(By.cssSelector((String)this.shadowHost));
            for (String innerHost : this.innerShadowHosts) {
                host = this.getElementInsideShadowTree(host, innerHost);
            }
            return this.getElementInsideShadowTree(host, this.target);
        }

        public List<WebElement> findElements(SearchContext context) {
            WebElement host = context.findElement(By.cssSelector((String)this.shadowHost));
            for (String innerHost : this.innerShadowHosts) {
                host = this.getElementInsideShadowTree(host, innerHost);
            }
            return this.getElementsInsideShadowTree(host, this.target);
        }

        private WebElement getElementInsideShadowTree(WebElement host, String target) {
            if (this.isShadowRootAttached(host)) {
                WebElement targetWebElement = (WebElement)this.getJavascriptExecutor((SearchContext)host).executeScript("return arguments[0].shadowRoot.querySelector(arguments[1])", new Object[]{host, target});
                if (targetWebElement == null) {
                    throw new NoSuchElementException("The element was not found: " + target);
                }
                return targetWebElement;
            }
            throw new NoSuchElementException("The element is not a shadow host or has 'closed' shadow-dom mode: " + host);
        }

        private boolean isShadowRootAttached(WebElement host) {
            return this.getJavascriptExecutor((SearchContext)host).executeScript("return arguments[0].shadowRoot", new Object[]{host}) != null;
        }

        private List<WebElement> getElementsInsideShadowTree(WebElement host, String sh) {
            return (List)this.getJavascriptExecutor((SearchContext)host).executeScript("return arguments[0].shadowRoot.querySelectorAll(arguments[1])", new Object[]{host, sh});
        }

        private JavascriptExecutor getJavascriptExecutor(SearchContext context) {
            JavascriptExecutor jsExecutor = context instanceof JavascriptExecutor ? (JavascriptExecutor)context : (JavascriptExecutor)((WrapsDriver)context).getWrappedDriver();
            return jsExecutor;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("By.cssSelector: ");
            sb.append(this.shadowHost).append(" ");
            if (this.innerShadowHosts.length > 0) {
                sb.append(Arrays.toString(this.innerShadowHosts)).append(" ");
            }
            sb.append(this.target);
            return sb.toString();
        }
    }
}

