/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.BrowserResizer;
import com.codeborne.selenide.webdriver.ChromeDriverFactory;
import com.codeborne.selenide.webdriver.DefaultDriverFactory;
import com.codeborne.selenide.webdriver.EdgeDriverFactory;
import com.codeborne.selenide.webdriver.FirefoxDriverFactory;
import com.codeborne.selenide.webdriver.InternetExplorerDriverFactory;
import com.codeborne.selenide.webdriver.LegacyFirefoxDriverFactory;
import com.codeborne.selenide.webdriver.OperaDriverFactory;
import com.codeborne.selenide.webdriver.RemoteDriverFactory;
import com.codeborne.selenide.webdriver.WebDriverBinaryManager;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    protected List<AbstractDriverFactory> factories = Arrays.asList(new RemoteDriverFactory(), new ChromeDriverFactory(), new LegacyFirefoxDriverFactory(), new FirefoxDriverFactory(), new EdgeDriverFactory(), new InternetExplorerDriverFactory(), new OperaDriverFactory());
    protected WebDriverBinaryManager webDriverBinaryManager = new WebDriverBinaryManager();
    protected BrowserResizer browserResizer = new BrowserResizer();

    public WebDriver createWebDriver(Config config, Proxy proxy) {
        log.debug("browser={}", (Object)config.browser());
        log.debug("browser.version={}", (Object)config.browserVersion());
        log.debug("remote={}", (Object)config.remote());
        log.debug("browserSize={}", (Object)config.browserSize());
        log.debug("startMaximized={}", (Object)config.startMaximized());
        Browser browser = new Browser(config.browser(), config.headless());
        if (config.driverManagerEnabled() && config.remote() == null) {
            this.webDriverBinaryManager.setupBinaryPath(browser);
        }
        WebDriver webdriver = this.factories.stream().filter(factory -> factory.supports(config, browser)).findAny().map(driverFactory -> driverFactory.create(config, proxy)).orElseGet(() -> new DefaultDriverFactory().create(config, proxy));
        webdriver = this.browserResizer.adjustBrowserSize(config, browser, webdriver);
        webdriver = this.browserResizer.adjustBrowserPosition(config, webdriver);
        this.logBrowserVersion(webdriver);
        log.info("Selenide v. {}", (Object)SelenideDriver.class.getPackage().getImplementationVersion());
        this.logSeleniumInfo(config);
        return webdriver;
    }

    protected void logSeleniumInfo(Config config) {
        if (config.remote() == null) {
            BuildInfo seleniumInfo = new BuildInfo();
            log.info("Selenium WebDriver v. {} build time: {}", (Object)seleniumInfo.getReleaseLabel(), (Object)seleniumInfo.getBuildTime());
        }
    }

    protected void logBrowserVersion(WebDriver webdriver) {
        if (webdriver instanceof HasCapabilities) {
            Capabilities capabilities = ((HasCapabilities)webdriver).getCapabilities();
            log.info("BrowserName={} Version={} Platform={}", new Object[]{capabilities.getBrowserName(), capabilities.getVersion(), capabilities.getPlatform()});
        } else {
            log.info("BrowserName={}", (Object)webdriver.getClass().getName());
        }
    }
}

