/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.conditions.And;
import com.codeborne.selenide.conditions.Attribute;
import com.codeborne.selenide.conditions.AttributeWithValue;
import com.codeborne.selenide.conditions.CaseSensitiveText;
import com.codeborne.selenide.conditions.Checked;
import com.codeborne.selenide.conditions.CssClass;
import com.codeborne.selenide.conditions.CssValue;
import com.codeborne.selenide.conditions.CustomMatch;
import com.codeborne.selenide.conditions.Disabled;
import com.codeborne.selenide.conditions.Enabled;
import com.codeborne.selenide.conditions.ExactText;
import com.codeborne.selenide.conditions.ExactTextCaseSensitive;
import com.codeborne.selenide.conditions.Exist;
import com.codeborne.selenide.conditions.ExplainedCondition;
import com.codeborne.selenide.conditions.Focused;
import com.codeborne.selenide.conditions.Hidden;
import com.codeborne.selenide.conditions.IsImageLoaded;
import com.codeborne.selenide.conditions.MatchAttributeWithValue;
import com.codeborne.selenide.conditions.MatchText;
import com.codeborne.selenide.conditions.NamedCondition;
import com.codeborne.selenide.conditions.Not;
import com.codeborne.selenide.conditions.Or;
import com.codeborne.selenide.conditions.PseudoElementPropertyWithValue;
import com.codeborne.selenide.conditions.Selected;
import com.codeborne.selenide.conditions.SelectedText;
import com.codeborne.selenide.conditions.Text;
import com.codeborne.selenide.conditions.Value;
import com.codeborne.selenide.conditions.Visible;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Arrays;
import java.util.function.Predicate;
import org.openqa.selenium.WebElement;

public abstract class Condition {
    public static final Condition visible = new Visible();
    public static final Condition exist = new Exist();
    public static final Condition hidden = new Hidden();
    public static final Condition appear = visible;
    public static final Condition appears = visible;
    public static final Condition disappears = hidden;
    public static final Condition disappear = hidden;
    public static final Condition readonly = Condition.attribute("readonly");
    public static final Condition empty = Condition.and("empty", Condition.exactValue(""), Condition.exactText(""));
    public static final Condition image = new IsImageLoaded();
    public static final Condition focused = new Focused();
    public static final Condition enabled = new Enabled();
    public static final Condition disabled = new Disabled();
    public static final Condition selected = new Selected();
    public static final Condition checked = new Checked();
    private final String name;
    private final boolean absentElementMatchesCondition;

    @CheckReturnValue
    public static Condition attribute(String attributeName) {
        return new Attribute(attributeName);
    }

    @CheckReturnValue
    public static Condition attribute(String attributeName, String expectedAttributeValue) {
        return new AttributeWithValue(attributeName, expectedAttributeValue);
    }

    @CheckReturnValue
    public static Condition attributeMatching(String attributeName, String attributeRegex) {
        return new MatchAttributeWithValue(attributeName, attributeRegex);
    }

    @CheckReturnValue
    public static Condition value(String expectedValue) {
        return new Value(expectedValue);
    }

    @CheckReturnValue
    public static Condition pseudo(String pseudoElementName, String propertyName, String expectedValue) {
        return new PseudoElementPropertyWithValue(pseudoElementName, propertyName, expectedValue);
    }

    @CheckReturnValue
    public static Condition pseudo(String pseudoElementName, String expectedValue) {
        return new PseudoElementPropertyWithValue(pseudoElementName, "content", expectedValue);
    }

    @CheckReturnValue
    public static Condition exactValue(String value) {
        return Condition.attribute("value", value);
    }

    @CheckReturnValue
    public static Condition name(String name) {
        return Condition.attribute("name", name);
    }

    @CheckReturnValue
    public static Condition type(String type) {
        return Condition.attribute("type", type);
    }

    @CheckReturnValue
    public static Condition id(String id) {
        return Condition.attribute("id", id);
    }

    @CheckReturnValue
    public static Condition matchesText(String text) {
        return Condition.matchText(text);
    }

    @CheckReturnValue
    public static Condition matchText(String regex) {
        return new MatchText(regex);
    }

    @CheckReturnValue
    public static Condition text(String text) {
        return new Text(text);
    }

    @CheckReturnValue
    public static Condition selectedText(String expectedText) {
        return new SelectedText(expectedText);
    }

    @CheckReturnValue
    public static Condition textCaseSensitive(String text) {
        return new CaseSensitiveText(text);
    }

    @CheckReturnValue
    public static Condition exactText(String text) {
        return new ExactText(text);
    }

    @CheckReturnValue
    public static Condition exactTextCaseSensitive(String text) {
        return new ExactTextCaseSensitive(text);
    }

    @CheckReturnValue
    public static Condition cssClass(String cssClass) {
        return new CssClass(cssClass);
    }

    @CheckReturnValue
    public static Condition cssValue(String propertyName, String expectedValue) {
        return new CssValue(propertyName, expectedValue);
    }

    @CheckReturnValue
    public static Condition match(String description, Predicate<WebElement> predicate) {
        return new CustomMatch(description, predicate);
    }

    @CheckReturnValue
    public static Condition not(Condition condition) {
        return condition.negate();
    }

    public Condition negate() {
        return new Not(this, this.absentElementMatchesCondition);
    }

    @CheckReturnValue
    public static Condition and(String name, Condition ... conditions) {
        return new And(name, Arrays.asList(conditions));
    }

    @CheckReturnValue
    public static Condition or(String name, Condition ... conditions) {
        return new Or(name, Arrays.asList(conditions));
    }

    @CheckReturnValue
    public static Condition be(Condition delegate) {
        return Condition.wrap("be", delegate);
    }

    @CheckReturnValue
    public static Condition have(Condition delegate) {
        return Condition.wrap("have", delegate);
    }

    private static Condition wrap(String prefix, Condition delegate) {
        return new NamedCondition(prefix, delegate);
    }

    public Condition(String name) {
        this(name, false);
    }

    public Condition(String name, boolean absentElementMatchesCondition) {
        this.name = name;
        this.absentElementMatchesCondition = absentElementMatchesCondition;
    }

    public abstract boolean apply(Driver var1, WebElement var2);

    public boolean applyNull() {
        return this.absentElementMatchesCondition;
    }

    public String actualValue(Driver driver, WebElement element) {
        return null;
    }

    @CheckReturnValue
    public Condition because(String message) {
        return new ExplainedCondition(this, message);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public boolean missingElementSatisfiesCondition() {
        return this.absentElementMatchesCondition;
    }
}

