/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.selector.ByShadow;
import com.google.errorprone.annotations.CheckReturnValue;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.Quotes;

public class Selectors {
    private static final String NORMALIZE_SPACE_XPATH = "normalize-space(translate(string(.), '\t\n\r\u00a0', '    '))";

    @CheckReturnValue
    public static By withText(String elementText) {
        return new WithText(elementText);
    }

    @CheckReturnValue
    public static By byText(String elementText) {
        return new ByText(elementText);
    }

    @CheckReturnValue
    public static By byAttribute(String attributeName, String attributeValue) {
        String escapedAttributeValue = attributeValue.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"");
        return By.cssSelector((String)String.format("[%s=\"%s\"]", attributeName, escapedAttributeValue));
    }

    @CheckReturnValue
    public static By shadowCss(String target, String shadowHost, String ... innerShadowHosts) {
        return ByShadow.cssSelector(target, shadowHost, innerShadowHosts);
    }

    @CheckReturnValue
    public static By by(String attributeName, String attributeValue) {
        return Selectors.byAttribute(attributeName, attributeValue);
    }

    @CheckReturnValue
    public static By byTitle(String title) {
        return Selectors.byAttribute("title", title);
    }

    @CheckReturnValue
    public static By byValue(String value) {
        return Selectors.byAttribute("value", value);
    }

    @CheckReturnValue
    public static By byName(String name) {
        return By.name((String)name);
    }

    @CheckReturnValue
    public static By byXpath(String xpath) {
        return By.xpath((String)xpath);
    }

    @CheckReturnValue
    public static By byLinkText(String linkText) {
        return By.linkText((String)linkText);
    }

    @CheckReturnValue
    public static By byPartialLinkText(String partialLinkText) {
        return By.partialLinkText((String)partialLinkText);
    }

    @CheckReturnValue
    public static By byId(String id) {
        return By.id((String)id);
    }

    @CheckReturnValue
    public static By byCssSelector(String css) {
        return By.cssSelector((String)css);
    }

    @CheckReturnValue
    public static By byClassName(String className) {
        return By.className((String)className);
    }

    @CheckReturnValue
    public static By byTagName(String tagName) {
        return By.tagName((String)tagName);
    }

    public static class WithText
    extends By.ByXPath {
        protected final String elementText;

        public WithText(String elementText) {
            super(".//*/text()[contains(normalize-space(translate(string(.), '\t\n\r\u00a0', '    ')), " + Quotes.escape((String)elementText) + ")]/parent::*");
            this.elementText = elementText;
        }

        public String toString() {
            return "with text: " + this.elementText;
        }

        String getXPath() {
            return super.toString().replace("By.xpath: ", "");
        }
    }

    public static class ByText
    extends By.ByXPath {
        protected final String elementText;

        public ByText(String elementText) {
            super(".//*/text()[normalize-space(translate(string(.), '\t\n\r\u00a0', '    ')) = " + Quotes.escape((String)elementText) + "]/parent::*");
            this.elementText = elementText;
        }

        public String toString() {
            return "by text: " + this.elementText;
        }

        String getXPath() {
            return super.toString().replace("By.xpath: ", "");
        }
    }
}

