/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import org.openqa.selenium.WebElement;

public class TextsInAnyOrder
extends ExactTexts {
    public TextsInAnyOrder(String ... expectedTexts) {
        super(expectedTexts);
    }

    public TextsInAnyOrder(List<String> expectedTexts) {
        super(expectedTexts);
    }

    @Override
    public boolean test(List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return false;
        }
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            String expectedText = (String)this.expectedTexts.get(i);
            boolean bFound = false;
            for (WebElement element : elements) {
                if (!Html.text.contains(element.getText(), expectedText)) continue;
                bFound = true;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "TextsInAnyOrder " + this.expectedTexts;
    }
}

