/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.WebElementSource;
import org.openqa.selenium.WebElement;

public class Click
implements Command<Void> {
    @Override
    public Void execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        if (args == null || args.length == 0) {
            this.click(locator.driver(), locator.findAndAssertElementIsInteractable());
        } else if (args.length == 2) {
            this.click(locator.driver(), locator.findAndAssertElementIsInteractable(), (Integer)args[0], (Integer)args[1]);
        }
        return null;
    }

    protected void click(Driver driver, WebElement element) {
        if (driver.config().clickViaJs()) {
            this.click(driver, element, 0, 0);
        } else {
            element.click();
        }
    }

    protected void click(Driver driver, WebElement element, int offsetX, int offsetY) {
        if (driver.config().clickViaJs()) {
            driver.executeJavaScript("var rect = arguments[0].getBoundingClientRect();arguments[0].dispatchEvent(new MouseEvent('click', { 'view': window, 'bubbles': true, 'cancelable': true, 'clientX': rect.left + rect.width/2 + arguments[1], 'clientY': rect.top + rect.height/2 + arguments[2]}))", element, offsetX, offsetY);
        } else {
            driver.actions().moveToElement(element, offsetX, offsetY).click().build().perform();
        }
    }
}

