/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class And
extends Condition {
    private final List<Condition> conditions;
    private Condition lastFailedCondition;

    public And(String name, List<Condition> conditions) {
        super(name);
        this.conditions = conditions;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        this.lastFailedCondition = null;
        for (Condition c : this.conditions) {
            if (c.apply(driver, element)) continue;
            this.lastFailedCondition = c;
            return false;
        }
        return true;
    }

    @Override
    public String actualValue(Driver driver, WebElement element) {
        return this.lastFailedCondition == null ? null : this.lastFailedCondition.actualValue(driver, element);
    }

    @Override
    public String toString() {
        return this.lastFailedCondition == null ? super.toString() : this.lastFailedCondition.toString();
    }
}

