/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.DownloadDetector;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.proxy.DownloadedFile;
import com.codeborne.selenide.proxy.FileDownloadFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFileWithProxyServer {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileWithProxyServer.class);
    private final Waiter waiter;

    DownloadFileWithProxyServer(Waiter waiter) {
        this.waiter = waiter;
    }

    public DownloadFileWithProxyServer() {
        this(new Waiter());
    }

    public File download(WebElementSource anyClickableElement, WebElement clickable, SelenideProxyServer proxyServer, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        return this.clickAndInterceptFileByProxyServer(anyClickableElement, clickable, proxyServer, timeout, fileFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File clickAndInterceptFileByProxyServer(WebElementSource anyClickableElement, WebElement clickable, SelenideProxyServer proxyServer, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        Config config = anyClickableElement.driver().config();
        WebDriver webDriver = anyClickableElement.driver().getWebDriver();
        String currentWindowHandle = webDriver.getWindowHandle();
        Set currentWindows = webDriver.getWindowHandles();
        FileDownloadFilter filter = (FileDownloadFilter)proxyServer.responseFilter("download");
        filter.activate();
        try {
            this.waiter.wait(filter, new PreviousDownloadsCompleted(), timeout, config.pollingInterval());
            filter.reset();
            clickable.click();
            this.waiter.wait(filter, new HasDownloads(fileFilter), timeout, config.pollingInterval());
            File file = this.firstDownloadedFile(anyClickableElement, filter, timeout, fileFilter);
            return file;
        }
        finally {
            filter.deactivate();
            this.closeNewWindows(webDriver, currentWindowHandle, currentWindows);
        }
    }

    private void closeNewWindows(WebDriver webDriver, String currentWindowHandle, Set<String> currentWindows) {
        Set windowHandles = webDriver.getWindowHandles();
        if (windowHandles.size() != currentWindows.size()) {
            HashSet newWindows = new HashSet(windowHandles);
            newWindows.removeAll(currentWindows);
            log.info("File has been opened in a new window, let's close {} new windows", (Object)newWindows.size());
            for (String newWindow : newWindows) {
                log.info("  Let's close {}", (Object)newWindow);
                try {
                    webDriver.switchTo().window(newWindow);
                    webDriver.close();
                }
                catch (NoSuchWindowException windowHasBeenClosedMeanwhile) {
                    log.info("  Failed to close {}: {}", (Object)newWindow, (Object)Cleanup.of.webdriverExceptionMessage(windowHasBeenClosedMeanwhile));
                }
                catch (Exception e) {
                    log.warn("  Failed to close {}", (Object)newWindow, (Object)e);
                }
            }
            webDriver.switchTo().window(currentWindowHandle);
        }
    }

    private File firstDownloadedFile(WebElementSource anyClickableElement, FileDownloadFilter filter, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        List<DownloadedFile> files = filter.getDownloadedFiles();
        if (files.isEmpty()) {
            throw new FileNotFoundException("Failed to download file " + anyClickableElement + " in " + timeout + " ms." + filter.responsesAsString());
        }
        log.info(filter.downloadedFilesAsString());
        log.info("Just in case, all intercepted responses: {}", (Object)filter.responsesAsString());
        return files.stream().filter(fileFilter::match).sorted(new DownloadDetector()).findFirst().orElseThrow(() -> new FileNotFoundException(String.format("Failed to download file %s in %d ms.%s %n%s", anyClickableElement, timeout, fileFilter.description(), filter.responsesAsString()))).getFile();
    }

    private static class PreviousDownloadsCompleted
    implements Predicate<FileDownloadFilter> {
        private int downloadsCount = -1;

        private PreviousDownloadsCompleted() {
        }

        @Override
        public boolean test(FileDownloadFilter filter) {
            try {
                boolean bl = this.downloadsCount == filter.getDownloadedFiles().size();
                return bl;
            }
            finally {
                this.downloadsCount = filter.getDownloadedFiles().size();
            }
        }
    }

    private static class HasDownloads
    implements Predicate<FileDownloadFilter> {
        private final FileFilter fileFilter;

        private HasDownloads(FileFilter fileFilter) {
            this.fileFilter = fileFilter;
        }

        @Override
        public boolean test(FileDownloadFilter filter) {
            return !filter.getDownloadedFiles(this.fileFilter).isEmpty();
        }
    }
}

