/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.Configuration;
import com.codeborne.selenide.Screenshots;
import com.codeborne.selenide.WebDriverRunner;
import com.codeborne.selenide.ex.ErrorMessages;
import com.codeborne.selenide.ex.UIAssertionError;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenShooterExtension
implements BeforeEachCallback,
AfterEachCallback {
    private static final Logger log = LoggerFactory.getLogger(ScreenShooterExtension.class);
    private final boolean captureSuccessfulTests;

    public ScreenShooterExtension() {
        this(false);
    }

    public ScreenShooterExtension(boolean captureSuccessfulTests) {
        this.captureSuccessfulTests = captureSuccessfulTests;
    }

    public ScreenShooterExtension to(String folderWithScreenshots) {
        Configuration.reportsFolder = folderWithScreenshots;
        return this;
    }

    public void beforeEach(ExtensionContext context) {
        Optional testClass = context.getTestClass();
        String className = testClass.map(Class::getName).orElse("EmptyClass");
        Optional testMethod = context.getTestMethod();
        String methodName = testMethod.map(Method::getName).orElse("emptyMethod");
        Screenshots.startContext(className, methodName);
    }

    public void afterEach(ExtensionContext context) {
        if (this.captureSuccessfulTests) {
            log.info(ErrorMessages.screenshot(WebDriverRunner.driver()));
        } else {
            context.getExecutionException().ifPresent(error -> {
                if (!(error instanceof UIAssertionError)) {
                    log.info(ErrorMessages.screenshot(WebDriverRunner.driver()));
                }
            });
        }
        Screenshots.finishContext();
    }
}

