/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.MergeableCapabilities;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverFactory.class);
    private static final Pattern REGEX_COMMAS_IN_VALUES = Pattern.compile(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    private static final Pattern REGEX_REMOVE_QUOTES = Pattern.compile("\"", 16);

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.chrome.driver")) {
            WebDriverManager.chromedriver().setup();
        }
    }

    @Override
    public WebDriver create(Config config, Browser browser, Proxy proxy) {
        MutableCapabilities chromeOptions = this.createCapabilities(config, browser, proxy);
        log.debug("Chrome options: {}", (Object)chromeOptions);
        return new ChromeDriver(this.buildService(), (Capabilities)chromeOptions);
    }

    protected ChromeDriverService buildService() {
        return ChromeDriverService.createDefaultService();
    }

    @Override
    public MutableCapabilities createCapabilities(Config config, Browser browser, Proxy proxy) {
        ChromeOptions options = new ChromeOptions();
        options.setHeadless(config.headless());
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            options.setBinary(config.browserBinary());
        }
        options.addArguments(this.createChromeArguments(config, browser));
        options.setExperimentalOption("excludeSwitches", (Object)this.excludeSwitches());
        options.setExperimentalOption("prefs", this.prefs(config));
        this.setMobileEmulation(config, options);
        return new MergeableCapabilities((Capabilities)options, (Capabilities)this.createCommonCapabilities(config, browser, proxy));
    }

    protected List<String> createChromeArguments(Config config, Browser browser) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--proxy-bypass-list=<-loopback>");
        arguments.addAll(this.parseArguments(System.getProperty("chromeoptions.args")));
        return arguments;
    }

    protected String[] excludeSwitches() {
        return new String[]{"enable-automation", "load-extension"};
    }

    private void setMobileEmulation(Config config, ChromeOptions chromeOptions) {
        Map<String, Object> mobileEmulation = this.mobileEmulation(config);
        if (!mobileEmulation.isEmpty()) {
            chromeOptions.setExperimentalOption("mobileEmulation", mobileEmulation);
        }
    }

    protected Map<String, Object> mobileEmulation(Config config) {
        String mobileEmulation = System.getProperty("chromeoptions.mobileEmulation", "");
        return this.parsePreferencesFromString(mobileEmulation);
    }

    protected Map<String, Object> prefs(Config config) {
        HashMap<String, Object> chromePreferences = new HashMap<String, Object>();
        chromePreferences.put("credentials_enable_service", false);
        if (config.remote() == null) {
            chromePreferences.put("download.default_directory", this.downloadsFolder(config));
        }
        chromePreferences.putAll(this.parsePreferencesFromString(System.getProperty("chromeoptions.prefs", "")));
        return chromePreferences;
    }

    protected String downloadsFolder(Config config) {
        return new File(config.downloadsFolder()).getAbsolutePath();
    }

    private Map<String, Object> parsePreferencesFromString(String preferencesString) {
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        List<String> allPrefs = this.parseCSV(preferencesString);
        for (String pref : allPrefs) {
            String[] keyValue = this.removeQuotes(pref).split("=");
            if (keyValue.length == 1) {
                log.warn("Missing '=' sign while parsing <key=value> pairs from {}. Key '{}' is ignored.", (Object)preferencesString, (Object)keyValue[0]);
                continue;
            }
            if (keyValue.length > 2) {
                log.warn("More than one '=' sign while parsing <key=value> pairs from {}. Key '{}' is ignored.", (Object)preferencesString, (Object)keyValue[0]);
                continue;
            }
            Object prefValue = this.convertStringToNearestObjectType(keyValue[1]);
            prefs.put(keyValue[0], prefValue);
        }
        return prefs;
    }

    private List<String> parseArguments(String arguments) {
        return this.parseCSV(arguments).stream().map(this::removeQuotes).collect(Collectors.toList());
    }

    private String removeQuotes(String value) {
        return REGEX_REMOVE_QUOTES.matcher(value).replaceAll(Matcher.quoteReplacement(""));
    }

    final List<String> parseCSV(String csvString) {
        return StringUtils.isBlank((CharSequence)csvString) ? Collections.emptyList() : Arrays.asList(REGEX_COMMAS_IN_VALUES.split(csvString));
    }
}

