/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(OperaDriverFactory.class);

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.opera.driver")) {
            WebDriverManager.operadriver().setup();
        }
    }

    @Override
    public WebDriver create(Config config, Browser browser, Proxy proxy) {
        return new OperaDriver(this.createCapabilities(config, browser, proxy));
    }

    public OperaOptions createCapabilities(Config config, Browser browser, Proxy proxy) {
        OperaOptions operaOptions = new OperaOptions();
        if (config.headless()) {
            throw new InvalidArgumentException("headless browser not supported in Opera. Set headless property to false.");
        }
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            operaOptions.setBinary(config.browserBinary());
        }
        operaOptions.merge((Capabilities)this.createCommonCapabilities(config, browser, proxy));
        return operaOptions;
    }
}

