/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Stopwatch {
    private final long endTimeNano;

    public Stopwatch(long timeoutMs) {
        this.endTimeNano = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMs);
    }

    @CheckReturnValue
    public boolean isTimeoutReached() {
        return System.nanoTime() > this.endTimeNano;
    }

    public void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

