/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.webdriver.AbstractDriverFactory;
import com.codeborne.selenide.webdriver.CdpClient;
import io.github.bonigarcia.wdm.WebDriverManager;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class EdgeDriverFactory
extends AbstractDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(EdgeDriverFactory.class);
    private static final int FIRST_VERSION_BASED_ON_CHROMIUM = 75;
    private static String browserVersion = null;
    private final CdpClient cdpClient = new CdpClient();

    @Override
    public void setupWebdriverBinary() {
        if (this.isSystemPropertyNotSet("webdriver.edge.driver")) {
            WebDriverManager manager = WebDriverManager.edgedriver();
            manager.setup();
            browserVersion = manager.getDownloadedVersion();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebDriver create(Config config, Browser browser, @Nullable Proxy proxy) {
        EdgeOptions options = this.createCapabilities(config, browser, proxy);
        EdgeDriverService driverService = this.createDriverService(config);
        EdgeDriver driver = new EdgeDriver(driverService, options);
        if (this.isChromiumBased()) {
            this.cdpClient.setDownloadsFolder((DriverService)driverService, (RemoteWebDriver)driver, this.downloadsFolder(config));
        }
        return driver;
    }

    private EdgeDriverService createDriverService(Config config) {
        return (EdgeDriverService)((EdgeDriverService.Builder)new EdgeDriverService.Builder().withLogFile(this.webdriverLog(config))).build();
    }

    @CheckReturnValue
    @Nonnull
    public EdgeOptions createCapabilities(Config config, Browser browser, @Nullable Proxy proxy) {
        MutableCapabilities capabilities = this.createCommonCapabilities(config, browser, proxy);
        if (this.isChromiumBased()) {
            capabilities.setCapability("acceptInsecureCerts", true);
        }
        EdgeOptions options = new EdgeOptions();
        options.merge((Capabilities)capabilities);
        if (!config.browserBinary().isEmpty()) {
            log.info("Using browser binary: {}", (Object)config.browserBinary());
            log.warn("Changing browser binary not supported in Edge, setting will be ignored.");
        }
        return options;
    }

    @CheckReturnValue
    private boolean isChromiumBased() {
        return browserVersion == null || this.majorVersion(browserVersion) >= 75;
    }
}

