/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.SelenideElementListIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ElementsCollection
extends AbstractList<SelenideElement> {
    private final WebElementsCollection collection;

    public ElementsCollection(WebElementsCollection collection) {
        this.collection = collection;
    }

    public ElementsCollection(Driver driver, Collection<? extends WebElement> elements) {
        this(new WebElementsCollectionWrapper(driver, elements));
    }

    public ElementsCollection(Driver driver, String cssSelector) {
        this(driver, By.cssSelector((String)cssSelector));
    }

    public ElementsCollection(Driver driver, By seleniumSelector) {
        this(new BySelectorCollection(driver, seleniumSelector));
    }

    public ElementsCollection(Driver driver, WebElement parent, String cssSelector) {
        this(driver, parent, By.cssSelector((String)cssSelector));
    }

    public ElementsCollection(Driver driver, WebElement parent, By seleniumSelector) {
        this(new BySelectorCollection(driver, (SearchContext)parent, seleniumSelector));
    }

    @Nonnull
    public ElementsCollection shouldHaveSize(int expectedSize) {
        return this.shouldHave(CollectionCondition.size(expectedSize));
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition ... conditions) {
        return this.should("be", this.driver().config().timeout(), conditions);
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition condition, long timeoutMs) {
        return this.should("be", timeoutMs, this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition ... conditions) {
        return this.should("have", this.driver().config().timeout(), conditions);
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition condition, long timeoutMs) {
        return this.should("have", timeoutMs, this.toArray(condition));
    }

    private CollectionCondition[] toArray(CollectionCondition condition) {
        return new CollectionCondition[]{condition};
    }

    protected ElementsCollection should(String prefix, long timeoutMs, CollectionCondition ... conditions) {
        ErrorsCollector.validateAssertionMode(this.driver().config());
        SelenideLog log = SelenideLogger.beginStep(this.collection.description(), "should " + prefix, conditions);
        try {
            for (CollectionCondition condition : conditions) {
                this.waitUntil(condition, timeoutMs);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), error, timeoutMs);
            SelenideLogger.commitStep(log, wrappedError);
            switch (this.driver().config().assertionMode()) {
                case SOFT: {
                    return this;
                }
            }
            throw wrappedError;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void waitUntil(CollectionCondition condition, long timeoutMs) {
        Object lastError = null;
        List<WebElement> actualElements = null;
        Stopwatch stopwatch = new Stopwatch(timeoutMs);
        do {
            try {
                actualElements = this.collection.getElements();
                if (condition.test(actualElements)) {
                    return;
                }
            }
            catch (JavascriptException e) {
                throw e;
            }
            catch (UIAssertionError | IndexOutOfBoundsException | WebDriverException elementNotFound) {
                if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                    throw Cleanup.of.wrap((Throwable)elementNotFound);
                }
                if (condition.applyNull()) {
                    return;
                }
                lastError = elementNotFound;
            }
            this.sleep(this.driver().config().pollingInterval());
        } while (!stopwatch.isTimeoutReached());
        if (lastError instanceof IndexOutOfBoundsException) {
            throw new ElementNotFound(this.collection.driver(), this.collection.description(), Condition.exist, (Throwable)lastError);
        }
        if (lastError instanceof UIAssertionError) {
            throw (UIAssertionError)((Object)lastError);
        }
        condition.fail(this.collection, actualElements, (Exception)lastError, timeoutMs);
    }

    void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public ElementsCollection filter(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, condition));
    }

    @Nonnull
    public ElementsCollection filterBy(Condition condition) {
        return this.filter(condition);
    }

    @Nonnull
    public ElementsCollection exclude(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    @Nonnull
    public ElementsCollection excludeWith(Condition condition) {
        return this.exclude(condition);
    }

    @Nonnull
    public SelenideElement find(Condition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    @Nonnull
    public SelenideElement findBy(Condition condition) {
        return this.find(condition);
    }

    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    @Nonnull
    public List<String> texts() {
        return ElementsCollection.texts(this.getElements());
    }

    @Nonnull
    public static List<String> texts(Collection<WebElement> elements) {
        return elements.stream().map(ElementsCollection::getText).collect(Collectors.toList());
    }

    private static String getText(WebElement element) {
        try {
            return element.getText();
        }
        catch (WebDriverException elementDisappeared) {
            return elementDisappeared.toString();
        }
    }

    @Nonnull
    public static String elementsToString(Driver driver, @Nullable Collection<WebElement> elements) {
        if (elements == null) {
            return "[not loaded yet...]";
        }
        if (elements.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("[").append(System.lineSeparator()).append("\t");
        for (WebElement element : elements) {
            if (sb.length() > 4) {
                sb.append(",").append(System.lineSeparator()).append("\t");
            }
            sb.append(Describe.describe(driver, element));
        }
        sb.append(System.lineSeparator()).append("]");
        return sb.toString();
    }

    @Override
    public SelenideElement get(int index) {
        return CollectionElement.wrap(this.collection, index);
    }

    @Nonnull
    public SelenideElement first() {
        return this.get(0);
    }

    @Nonnull
    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    @Nonnull
    public ElementsCollection first(int elements) {
        return new ElementsCollection(new HeadOfCollection(this.collection, elements));
    }

    @Nonnull
    public ElementsCollection last(int elements) {
        return new ElementsCollection(new TailOfCollection(this.collection, elements));
    }

    @Override
    public int size() {
        try {
            return this.getElements().size();
        }
        catch (IndexOutOfBoundsException outOfCollection) {
            return 0;
        }
    }

    @Override
    @Nonnull
    public Iterator<SelenideElement> iterator() {
        return new SelenideElementIterator(this.fetch());
    }

    @Override
    @Nonnull
    public ListIterator<SelenideElement> listIterator(int index) {
        return new SelenideElementListIterator(this.fetch(), index);
    }

    private WebElementsCollectionWrapper fetch() {
        List<WebElement> fetchedElements = this.collection.getElements();
        return new WebElementsCollectionWrapper(this.driver(), fetchedElements);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        List<WebElement> fetchedElements = this.collection.getElements();
        Object[] result = new Object[fetchedElements.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CollectionElement.wrap(this.collection, i);
        }
        return result;
    }

    @Nonnull
    public ElementsCollection snapshot() {
        return new ElementsCollection(this.fetch());
    }

    @Override
    public String toString() {
        try {
            return ElementsCollection.elementsToString(this.driver(), this.getElements());
        }
        catch (RuntimeException e) {
            return String.format("[%s]", Cleanup.of.webdriverExceptionMessage(e));
        }
    }

    private Driver driver() {
        return this.collection.driver();
    }
}

