/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.webdriver;

import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class CdpClient {
    private static final Logger log = LoggerFactory.getLogger(CdpClient.class);

    public void setDownloadsFolder(DriverService driverService, RemoteWebDriver driver, String downloadsFolder) {
        this.setDownloadsFolder(driverService.getUrl(), driver.getSessionId(), downloadsFolder);
    }

    public void setDownloadsFolder(URL remoteDriverUrl, SessionId driverSessionId, String downloadsFolder) {
        try {
            String command = this.command(downloadsFolder);
            this.post(remoteDriverUrl, driverSessionId, command);
            log.info("Downloading files to {}", (Object)downloadsFolder);
        }
        catch (IOException e) {
            String message = String.format("Failed to set downloads folder to %s", downloadsFolder);
            throw new RuntimeException(message, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    private String command(String downloadsFolder) {
        return "{  \"cmd\": \"Page.setDownloadBehavior\",\n  \"params\": {\n    \"behavior\": \"allow\", \n    \"downloadPath\": \"" + this.escapeForJson(downloadsFolder) + "\"\n  }\n}";
    }

    String escapeForJson(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    @CheckReturnValue
    @Nonnull
    private HttpPost request(String url, String command) {
        HttpPost request = new HttpPost(url);
        request.addHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)new StringEntity(command));
        return request;
    }

    private void post(URL remoteDriverUrl, SessionId driverSessionId, String command) throws IOException {
        String url = String.format("%s/session/%s/chromium/send_command", remoteDriverUrl, driverSessionId);
        HttpPost request = this.request(url, command);
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)request);
            int code = response.getCode();
            if (code != 200) {
                String error = response.getReasonPhrase();
                String message = String.format("Failed to send CDP command %s: status=%s, error=%s", command, code, error);
                throw new IOException(message);
            }
        }
    }
}

