/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebElementsCollection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class TailOfCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final int size;

    public TailOfCollection(WebElementsCollection originalCollection, int size) {
        this.originalCollection = originalCollection;
        this.size = size;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        List<WebElement> source = this.originalCollection.getElements();
        int sourceCollectionSize = source.size();
        return source.subList(this.startingIndex(sourceCollectionSize), sourceCollectionSize);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        List<WebElement> source = this.originalCollection.getElements();
        int sourceCollectionSize = source.size();
        int startingIndex = this.startingIndex(sourceCollectionSize);
        return this.originalCollection.getElement(startingIndex + index);
    }

    private int startingIndex(int sourceCollectionSize) {
        return sourceCollectionSize - Math.min(sourceCollectionSize, this.size);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.originalCollection.description() + ":last(" + this.size + ')';
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }
}

