/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.files.DownloadedFile;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.impl.Downloader;
import com.codeborne.selenide.impl.Downloads;
import com.codeborne.selenide.impl.FileHelper;
import com.codeborne.selenide.impl.Waiter;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WindowsCloser;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DownloadFileToFolder {
    private static final Logger log = LoggerFactory.getLogger(DownloadFileToFolder.class);
    private final Downloader downloader;
    private final Waiter waiter;
    private final WindowsCloser windowsCloser;

    DownloadFileToFolder(Downloader downloader, Waiter waiter, WindowsCloser windowsCloser) {
        this.downloader = downloader;
        this.waiter = waiter;
        this.windowsCloser = windowsCloser;
    }

    public DownloadFileToFolder() {
        this(new Downloader(), new Waiter(), new WindowsCloser());
    }

    @CheckReturnValue
    @Nonnull
    public File download(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        WebDriver webDriver = anyClickableElement.driver().getWebDriver();
        return this.windowsCloser.runAndCloseArisedWindows(webDriver, () -> this.clickAndWaitForNewFilesInDownloadsFolder(anyClickableElement, clickable, timeout, fileFilter));
    }

    @CheckReturnValue
    @Nonnull
    private File clickAndWaitForNewFilesInDownloadsFolder(WebElementSource anyClickableElement, WebElement clickable, long timeout, FileFilter fileFilter) throws FileNotFoundException {
        Driver driver = anyClickableElement.driver();
        Config config = driver.config();
        DownloadsFolder folder = driver.browserDownloadsFolder();
        if (folder == null) {
            throw new IllegalStateException("Downloads folder is not configured");
        }
        folder.cleanupBeforeDownload();
        long downloadStartedAt = System.currentTimeMillis();
        clickable.click();
        Downloads newDownloads = this.waitForNewFiles(timeout, fileFilter, config, folder, downloadStartedAt);
        File downloadedFile = newDownloads.firstDownloadedFile(anyClickableElement.toString(), timeout, fileFilter);
        return this.archiveFile(config, downloadedFile);
    }

    @Nonnull
    private Downloads waitForNewFiles(long timeout, FileFilter fileFilter, Config config, DownloadsFolder folder, long clickMoment) {
        HasDownloads hasDownloads = new HasDownloads(fileFilter, clickMoment);
        this.waiter.wait(folder, hasDownloads, timeout, config.pollingInterval());
        if (log.isInfoEnabled()) {
            log.info(hasDownloads.downloads.filesAsString());
        }
        if (log.isDebugEnabled()) {
            log.debug("All downloaded files in {}: {}", (Object)folder, folder.files());
        }
        return hasDownloads.downloads;
    }

    @Nonnull
    private File archiveFile(Config config, File downloadedFile) {
        File uniqueFolder = this.downloader.prepareTargetFolder(config);
        File archivedFile = new File(uniqueFolder, downloadedFile.getName());
        FileHelper.moveFile(downloadedFile, archivedFile);
        return archivedFile;
    }

    static boolean isFileModifiedLaterThan(File file, long timestamp) {
        return file.lastModified() >= timestamp / 1000L * 1000L;
    }

    @ParametersAreNonnullByDefault
    private static class HasDownloads
    implements Predicate<DownloadsFolder> {
        private final FileFilter fileFilter;
        private final long downloadStartedAt;
        Downloads downloads;

        private HasDownloads(FileFilter fileFilter, long downloadStartedAt) {
            this.fileFilter = fileFilter;
            this.downloadStartedAt = downloadStartedAt;
        }

        @Override
        public boolean test(DownloadsFolder folder) {
            this.downloads = new Downloads(this.newFiles(folder));
            return !this.downloads.files(this.fileFilter).isEmpty();
        }

        private List<DownloadedFile> newFiles(DownloadsFolder folder) {
            return folder.files().stream().filter(File::isFile).filter(file -> DownloadFileToFolder.isFileModifiedLaterThan(file, this.downloadStartedAt)).map(file -> new DownloadedFile((File)file, Collections.emptyMap())).collect(Collectors.toList());
        }
    }
}

