/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.ElementDescriber;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSelector;
import com.codeborne.selenide.impl.WebElementSource;
import com.codeborne.selenide.impl.WebElementWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ElementFinder
extends WebElementSource {
    private final ElementDescriber describe = Plugins.inject(ElementDescriber.class);
    private final Driver driver;
    private final SearchContext parent;
    private final By criteria;
    private final int index;

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, WebElement parent, String cssSelector) {
        return ElementFinder.wrap(driver, (SearchContext)parent, By.cssSelector((String)cssSelector), 0);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, String cssSelector, int index) {
        return ElementFinder.wrap(driver, null, By.cssSelector((String)cssSelector), index);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, WebElement parent, String cssSelector, int index) {
        return ElementFinder.wrap(driver, (SearchContext)WebElementWrapper.wrap(driver, parent), By.cssSelector((String)cssSelector), index);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, By criteria) {
        return ElementFinder.wrap(driver, null, criteria, 0);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideElement wrap(Driver driver, @Nullable SearchContext parent, By criteria, int index) {
        return ElementFinder.wrap(driver, SelenideElement.class, parent, criteria, index);
    }

    @CheckReturnValue
    @Nonnull
    public static <T extends SelenideElement> T wrap(Driver driver, Class<T> clazz, @Nullable SearchContext parent, By criteria, int index) {
        return (T)((SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)new SelenideElementProxy(new ElementFinder(driver, parent, criteria, index))));
    }

    ElementFinder(Driver driver, @Nullable SearchContext parent, By criteria, int index) {
        this.driver = driver;
        this.parent = parent;
        this.criteria = criteria;
        this.index = index;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return arg instanceof By ? ElementFinder.wrap(this.driver, (SearchContext)proxy, (By)arg, index) : ElementFinder.wrap(this.driver, (SearchContext)proxy, By.cssSelector((String)((String)arg)), index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? WebElementSelector.instance.findElement(this.driver, this.getSearchContext(), this.criteria) : WebElementSelector.instance.findElements(this.driver, this.getSearchContext(), this.criteria).get(this.index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> findAll() throws NoSuchElementException, IndexOutOfBoundsException {
        return this.index == 0 ? WebElementSelector.instance.findElements(this.driver(), this.getSearchContext(), this.criteria) : super.findAll();
    }

    @CheckReturnValue
    @Nonnull
    private SearchContext getSearchContext() {
        return this.parent == null ? this.driver().getWebDriver() : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).toWebElement() : this.parent);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable lastError) {
        if (this.parent instanceof SelenideElement) {
            ((SelenideElement)this.parent).should(Condition.exist);
        } else if (this.parent instanceof WebElement) {
            WebElementWrapper.wrap(this.driver(), (WebElement)this.parent).should(Condition.exist);
        }
        return super.createElementNotFoundError(condition, lastError);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.parent == null ? this.elementCriteria() : (this.parent instanceof SelenideElement ? ((SelenideElement)this.parent).getSearchCriteria() + "/" + this.elementCriteria() : this.elementCriteria());
    }

    @Nonnull
    private String elementCriteria() {
        return this.index == 0 ? this.describe.selector(this.criteria) : this.describe.selector(this.criteria) + '[' + this.index + ']';
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return "{" + this.getSearchCriteria() + '}';
    }
}

