/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class FileHelper {
    private static final Logger log = LoggerFactory.getLogger(FileHelper.class);

    private FileHelper() {
    }

    public static void writeToFile(byte[] source, File targetFile) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(source);){
            FileHelper.copyFile(in, targetFile);
        }
    }

    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);){
            FileHelper.copyFile(in, targetFile);
        }
    }

    public static void copyFile(InputStream in, File targetFile) throws IOException {
        FileHelper.ensureParentFolderExists(targetFile);
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void ensureParentFolderExists(File targetFile) {
        FileHelper.ensureFolderExists(targetFile.getParentFile());
    }

    @Nonnull
    public static File ensureFolderExists(File folder) {
        if (!folder.exists()) {
            log.info("Creating folder: {}", (Object)folder.getAbsolutePath());
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to create folder '" + folder.getAbsolutePath() + "'", e);
            }
        }
        return folder;
    }

    public static void moveFile(File srcFile, File destFile) {
        try {
            FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to move file " + srcFile.getAbsolutePath() + " to " + destFile.getAbsolutePath(), e);
        }
    }

    public static void deleteFolderIfEmpty(@Nonnull File folder) {
        File[] files;
        if (folder.isDirectory() && ((files = folder.listFiles()) == null || files.length == 0)) {
            if (folder.delete()) {
                log.info("Deleted empty folder: {}", (Object)folder.getAbsolutePath());
            } else {
                log.error("Failed to delete empty folder: {}", (Object)folder.getAbsolutePath());
            }
        }
    }
}

