/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.junit5;

import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.SelenideLogger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

@ParametersAreNonnullByDefault
public class SoftAssertsExtension
implements BeforeEachCallback,
AfterEachCallback {
    public static final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{SoftAssertsExtension.class});

    public void beforeEach(ExtensionContext context) {
        ErrorsCollector errorsCollector = new ErrorsCollector();
        SelenideLogger.addListener("softAssert", errorsCollector);
        context.getStore(namespace).put((Object)"softAssert", (Object)errorsCollector);
    }

    public void afterEach(ExtensionContext context) {
        SelenideLogger.removeListener("softAssert");
        ErrorsCollector errorsCollector = (ErrorsCollector)context.getStore(namespace).get((Object)"softAssert");
        errorsCollector.failIfErrors(context.getDisplayName());
    }
}

