/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class CssClass
extends Condition {
    private final String expectedCssClass;

    public CssClass(String expectedCssClass) {
        super("css class");
        this.expectedCssClass = expectedCssClass;
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        String actualCssClasses = element.getAttribute("class");
        return actualCssClasses != null && this.contains(actualCssClasses.split(" "), this.expectedCssClass);
    }

    @Override
    public String toString() {
        return String.format("%s '%s'", this.getName(), this.expectedCssClass);
    }

    private <T> boolean contains(T[] objects, T object) {
        for (T object1 : objects) {
            if (!object.equals(object1)) continue;
            return true;
        }
        return false;
    }
}

