/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.DownloadsFolder;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.LocalStorage;
import com.codeborne.selenide.Modal;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.SessionStorage;
import com.codeborne.selenide.SharedDownloadsFolder;
import com.codeborne.selenide.WebDriverLogs;
import com.codeborne.selenide.drivercommands.LazyDriver;
import com.codeborne.selenide.drivercommands.Navigator;
import com.codeborne.selenide.drivercommands.WebDriverWrapper;
import com.codeborne.selenide.files.FileFilters;
import com.codeborne.selenide.impl.DownloadFileWithHttpRequest;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.ScreenShotLaboratory;
import com.codeborne.selenide.impl.WebElementWrapper;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;

@ParametersAreNonnullByDefault
public class SelenideDriver {
    private static final Navigator navigator = new Navigator();
    private static final ScreenShotLaboratory screenshots = ScreenShotLaboratory.getInstance();
    private final Config config;
    private final Driver driver;
    private static final PageObjectFactory pageFactory = Plugins.inject(PageObjectFactory.class);
    private static DownloadFileWithHttpRequest downloadFileWithHttpRequest;

    public SelenideDriver(Config config) {
        this(config, Collections.emptyList());
    }

    public SelenideDriver(Config config, List<WebDriverEventListener> listeners) {
        this(config, new LazyDriver(config, null, listeners));
    }

    public SelenideDriver(Config config, Driver driver) {
        this.config = config;
        this.driver = driver;
    }

    public SelenideDriver(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy) {
        this(config, webDriver, selenideProxy, new SharedDownloadsFolder(config.downloadsFolder()));
    }

    public SelenideDriver(Config config, WebDriver webDriver, @Nullable SelenideProxyServer selenideProxy, DownloadsFolder browserDownloadsFolder) {
        this.config = config;
        this.driver = new WebDriverWrapper(config, webDriver, selenideProxy, browserDownloadsFolder);
    }

    @CheckReturnValue
    @Nonnull
    public Config config() {
        return this.config;
    }

    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }

    public void open() {
        navigator.open(this);
    }

    public void open(String relativeOrAbsoluteUrl) {
        navigator.open(this, relativeOrAbsoluteUrl);
    }

    public void open(URL absoluteUrl) {
        navigator.open(this, absoluteUrl);
    }

    public void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        navigator.open(this, relativeOrAbsoluteUrl, domain, login, password);
    }

    public void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        navigator.open(this, relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public void open(URL absoluteUrl, String domain, String login, String password) {
        navigator.open(this, absoluteUrl, domain, login, password);
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return this.open(relativeOrAbsoluteUrl, "", "", "", pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return this.open(absoluteUrl, "", "", "", pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        this.open(relativeOrAbsoluteUrl, domain, login, password);
        return this.page((Object)pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        this.open(absoluteUrl, domain, login, password);
        return this.page((Object)pageObjectClassClass);
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return pageFactory.page(this.driver(), pageObjectClass);
    }

    @CheckReturnValue
    @Nonnull
    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return pageFactory.page(this.driver(), pageObject);
    }

    public void refresh() {
        navigator.refresh(this.driver());
    }

    public void back() {
        navigator.back(this.driver());
    }

    public void forward() {
        navigator.forward(this.driver());
    }

    public void updateHash(String hash) {
        SelenideLogger.run("updateHash", hash, () -> {
            String localHash = hash.charAt(0) == '#' ? hash.substring(1) : hash;
            this.executeJavaScript("window.location.hash='" + localHash + "'", new Object[0]);
        });
    }

    @CheckReturnValue
    @Nonnull
    public Browser browser() {
        return this.driver().browser();
    }

    @CheckReturnValue
    @Nullable
    public SelenideProxyServer getProxy() {
        return this.driver().getProxy();
    }

    public boolean hasWebDriverStarted() {
        return this.driver().hasWebDriverStarted();
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver getWebDriver() {
        return this.driver.getWebDriver();
    }

    @Nonnull
    public WebDriver getAndCheckWebDriver() {
        return this.driver.getAndCheckWebDriver();
    }

    public void clearCookies() {
        SelenideLogger.run("clearCookies", "", () -> this.driver().clearCookies());
    }

    public void close() {
        this.driver.close();
    }

    public <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return this.driver().executeJavaScript(jsCode, arguments);
    }

    public <T> T executeAsyncJavaScript(String jsCode, Object ... arguments) {
        return this.driver().executeAsyncJavaScript(jsCode, arguments);
    }

    @CheckReturnValue
    @Nullable
    public WebElement getFocusedElement() {
        return (WebElement)this.executeJavaScript("return document.activeElement", new Object[0]);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideWait Wait() {
        return new SelenideWait(this.getWebDriver(), this.config().timeout(), this.config().pollingInterval());
    }

    public void zoom(double factor) {
        this.executeJavaScript("document.body.style.transform = 'scale(' + arguments[0] + ')';document.body.style.transformOrigin = '0 0';", factor);
    }

    @Nullable
    public String title() {
        return this.getWebDriver().getTitle();
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(WebElement webElement) {
        return WebElementWrapper.wrap(this.driver(), webElement);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(String cssSelector) {
        return this.find(cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(String cssSelector) {
        return this.find(By.cssSelector((String)cssSelector));
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement $x(String xpathExpression) {
        return this.find(By.xpath((String)xpathExpression));
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(By seleniumSelector) {
        return this.find(seleniumSelector);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(By seleniumSelector, int index) {
        return this.find(seleniumSelector, index);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement $(String cssSelector, int index) {
        return ElementFinder.wrap(this.driver(), cssSelector, index);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(By criteria) {
        return ElementFinder.wrap(this.driver(), null, criteria, 0);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(By criteria, int index) {
        return ElementFinder.wrap(this.driver(), null, criteria, index);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$(Collection<? extends WebElement> elements) {
        return new ElementsCollection(this.driver(), elements);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(this.driver(), cssSelector);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$x(String xpathExpression) {
        return this.$$(By.xpath((String)xpathExpression));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection findAll(By seleniumSelector) {
        return new ElementsCollection(this.driver(), seleniumSelector);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection findAll(String cssSelector) {
        return new ElementsCollection(this.driver(), By.cssSelector((String)cssSelector));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection $$(By criteria) {
        return this.findAll(criteria);
    }

    @CheckReturnValue
    @Nullable
    public SelenideElement getSelectedRadio(By radioField) {
        for (WebElement radio : this.$$(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return this.$(radio);
        }
        return null;
    }

    @CheckReturnValue
    @Nonnull
    public Modal modal() {
        return new Modal(this.driver());
    }

    @CheckReturnValue
    @Nonnull
    public WebDriverLogs getWebDriverLogs() {
        return new WebDriverLogs(this.driver());
    }

    public void clearBrowserLocalStorage() {
        this.executeJavaScript("localStorage.clear();", new Object[0]);
    }

    public boolean atBottom() {
        return (Boolean)this.executeJavaScript("return window.pageYOffset + window.innerHeight >= document.body.scrollHeight", new Object[0]);
    }

    @Nonnull
    public SelenideTargetLocator switchTo() {
        return this.driver().switchTo();
    }

    @CheckReturnValue
    @Nonnull
    public String url() {
        return this.getWebDriver().getCurrentUrl();
    }

    @CheckReturnValue
    @Nullable
    public String source() {
        return this.getWebDriver().getPageSource();
    }

    @CheckReturnValue
    @Nonnull
    public String getCurrentFrameUrl() {
        return this.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    @CheckReturnValue
    @Nonnull
    public String getUserAgent() {
        return this.driver().getUserAgent();
    }

    @CheckReturnValue
    @Nullable
    public String screenshot(String fileName) {
        return screenshots.takeScreenShot(this.driver(), fileName);
    }

    @CheckReturnValue
    @Nullable
    public <T> T screenshot(OutputType<T> outputType) {
        return screenshots.takeScreenShot(this.driver(), outputType);
    }

    @Nonnull
    public File download(String url) throws IOException, URISyntaxException {
        return this.download(new URI(url), this.config.timeout());
    }

    @Nonnull
    public File download(String url, long timeoutMs) throws IOException, URISyntaxException {
        return this.download(new URI(url), timeoutMs);
    }

    @Nonnull
    public File download(URI url) throws IOException {
        return this.download(url, this.config.timeout());
    }

    @Nonnull
    public File download(URI url, long timeoutMs) throws IOException {
        return SelenideDriver.downloadFileWithHttpRequest().download(this.driver(), url, timeoutMs, FileFilters.none());
    }

    @CheckReturnValue
    @Nonnull
    public LocalStorage getLocalStorage() {
        return new LocalStorage(this.driver());
    }

    @CheckReturnValue
    @Nonnull
    public SessionStorage getSessionStorage() {
        return new SessionStorage(this.driver());
    }

    private static synchronized DownloadFileWithHttpRequest downloadFileWithHttpRequest() {
        if (downloadFileWithHttpRequest == null) {
            downloadFileWithHttpRequest = new DownloadFileWithHttpRequest();
        }
        return downloadFileWithHttpRequest;
    }
}

