/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.Browser;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Modal;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SelenideTargetLocator;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.WebDriverLogs;
import com.codeborne.selenide.drivercommands.LazyDriver;
import com.codeborne.selenide.drivercommands.Navigator;
import com.codeborne.selenide.drivercommands.WebDriverWrapper;
import com.codeborne.selenide.impl.DownloadFileWithHttpRequest;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.SelenidePageFactory;
import com.codeborne.selenide.impl.WebElementWrapper;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class SelenideDriver {
    private final Navigator navigator = new Navigator();
    private static SelenidePageFactory pageFactory = new SelenidePageFactory();
    private static DownloadFileWithHttpRequest downloadFileWithHttpRequest = new DownloadFileWithHttpRequest();
    private final Config config;
    private final Driver driver;

    public SelenideDriver(Config config, Proxy userProvidedProxy, List<WebDriverEventListener> listeners) {
        this.config = config;
        this.driver = new LazyDriver(config, userProvidedProxy, listeners);
    }

    public SelenideDriver(Config config) {
        this(config, null, Collections.emptyList());
    }

    public SelenideDriver(Config config, WebDriver webDriver, SelenideProxyServer selenideProxy) {
        this.config = config;
        this.driver = new WebDriverWrapper(config, webDriver, selenideProxy);
    }

    public Config config() {
        return this.config;
    }

    public Driver driver() {
        return this.driver;
    }

    public void open(String relativeOrAbsoluteUrl) {
        this.navigator.open(this, relativeOrAbsoluteUrl);
    }

    public void open(URL absoluteUrl) {
        this.navigator.open(this, absoluteUrl);
    }

    public void open(String relativeOrAbsoluteUrl, String domain, String login, String password) {
        this.navigator.open(this, relativeOrAbsoluteUrl, domain, login, password);
    }

    public void open(String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        this.navigator.open(this, relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    public void open(URL absoluteUrl, String domain, String login, String password) {
        this.navigator.open(this, absoluteUrl, domain, login, password);
    }

    public <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return this.open(relativeOrAbsoluteUrl, "", "", "", pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass open(URL absoluteUrl, Class<PageObjectClass> pageObjectClassClass) {
        return this.open(absoluteUrl, "", "", "", pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass open(String relativeOrAbsoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        this.open(relativeOrAbsoluteUrl, domain, login, password);
        return this.page((Object)pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass open(URL absoluteUrl, String domain, String login, String password, Class<PageObjectClass> pageObjectClassClass) {
        this.open(absoluteUrl, domain, login, password);
        return this.page((Object)pageObjectClassClass);
    }

    public <PageObjectClass> PageObjectClass page(Class<PageObjectClass> pageObjectClass) {
        return pageFactory.page(this.driver(), pageObjectClass);
    }

    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(T pageObject) {
        return pageFactory.page(this.driver(), pageObject);
    }

    public void refresh() {
        this.navigator.refresh(this.driver());
    }

    public void back() {
        this.navigator.back(this.driver());
    }

    public void forward() {
        this.navigator.forward(this.driver());
    }

    public void updateHash(String hash) {
        String localHash = hash.charAt(0) == '#' ? hash.substring(1) : hash;
        this.executeJavaScript("window.location.hash='" + localHash + "'", new Object[0]);
    }

    public Browser browser() {
        return this.driver().browser();
    }

    public SelenideProxyServer getProxy() {
        return this.driver().getProxy();
    }

    public boolean hasWebDriverStarted() {
        return this.driver().hasWebDriverStarted();
    }

    public WebDriver getWebDriver() {
        return this.driver.getWebDriver();
    }

    public WebDriver getAndCheckWebDriver() {
        return this.driver.getAndCheckWebDriver();
    }

    public void clearCookies() {
        if (this.driver().hasWebDriverStarted()) {
            this.driver().getWebDriver().manage().deleteAllCookies();
        }
    }

    public void close() {
        this.driver.close();
    }

    public <T> T executeJavaScript(String jsCode, Object ... arguments) {
        return this.driver().executeJavaScript(jsCode, arguments);
    }

    public WebElement getFocusedElement() {
        return (WebElement)this.executeJavaScript("return document.activeElement", new Object[0]);
    }

    public SelenideWait Wait() {
        return new SelenideWait(this.getWebDriver(), this.config().timeout(), this.config().pollingInterval());
    }

    public void zoom(double factor) {
        this.executeJavaScript("document.body.style.transform = 'scale(' + arguments[0] + ')';document.body.style.transformOrigin = '0 0';", factor);
    }

    public String title() {
        return this.getWebDriver().getTitle();
    }

    public SelenideElement $(WebElement webElement) {
        return WebElementWrapper.wrap(this.driver(), webElement);
    }

    public SelenideElement $(String cssSelector) {
        return this.find(cssSelector);
    }

    public SelenideElement find(String cssSelector) {
        return this.find(By.cssSelector((String)cssSelector));
    }

    public SelenideElement $x(String xpathExpression) {
        return this.find(By.xpath((String)xpathExpression));
    }

    public SelenideElement $(By seleniumSelector) {
        return this.find(seleniumSelector);
    }

    public SelenideElement $(By seleniumSelector, int index) {
        return this.find(seleniumSelector, index);
    }

    public SelenideElement $(String cssSelector, int index) {
        return ElementFinder.wrap(this.driver(), cssSelector, index);
    }

    public SelenideElement find(By criteria) {
        return ElementFinder.wrap(this.driver(), null, criteria, 0);
    }

    public SelenideElement find(By criteria, int index) {
        return ElementFinder.wrap(this.driver(), null, criteria, index);
    }

    public ElementsCollection $$(Collection<? extends WebElement> elements) {
        return new ElementsCollection(this.driver(), elements);
    }

    public ElementsCollection $$(String cssSelector) {
        return new ElementsCollection(this.driver(), cssSelector);
    }

    public ElementsCollection $$x(String xpathExpression) {
        return this.$$(By.xpath((String)xpathExpression));
    }

    public ElementsCollection findAll(By seleniumSelector) {
        return new ElementsCollection(this.driver(), seleniumSelector);
    }

    public ElementsCollection $$(By criteria) {
        return this.findAll(criteria);
    }

    public SelenideElement getSelectedRadio(By radioField) {
        for (WebElement radio : this.$$(radioField)) {
            if (radio.getAttribute("checked") == null) continue;
            return this.$(radio);
        }
        return null;
    }

    public Modal modal() {
        return new Modal(this.driver());
    }

    public WebDriverLogs getWebDriverLogs() {
        return new WebDriverLogs(this.driver());
    }

    public void clearBrowserLocalStorage() {
        this.executeJavaScript("localStorage.clear();", new Object[0]);
    }

    public boolean atBottom() {
        return (Boolean)this.executeJavaScript("return window.pageYOffset + window.innerHeight >= document.body.scrollHeight", new Object[0]);
    }

    public SelenideTargetLocator switchTo() {
        return this.driver().switchTo();
    }

    public String url() {
        return this.getWebDriver().getCurrentUrl();
    }

    public String source() {
        return this.getWebDriver().getPageSource();
    }

    public String getCurrentFrameUrl() {
        return this.executeJavaScript("return window.location.href", new Object[0]).toString();
    }

    public String getUserAgent() {
        return this.driver().getUserAgent();
    }

    public File download(String url) throws IOException {
        return this.download(url, this.config.timeout());
    }

    public File download(String url, long timeoutMs) throws IOException {
        return downloadFileWithHttpRequest.download(this.driver(), url, timeoutMs);
    }
}

