/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.WebElementsCollection;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import org.openqa.selenium.WebElement;

public class FilteringCollection
implements WebElementsCollection {
    private final WebElementsCollection originalCollection;
    private final Predicate<WebElement> filter;

    public FilteringCollection(WebElementsCollection originalCollection, Predicate<WebElement> filter) {
        this.originalCollection = originalCollection;
        this.filter = filter;
    }

    public FilteringCollection(WebElementsCollection originalCollection, Condition filter) {
        this.originalCollection = originalCollection;
        this.filter = new ConditionPredicate(this.driver(), filter);
    }

    @Override
    public List<WebElement> getElements() {
        return new ArrayList<WebElement>(Collections2.filter(this.originalCollection.getElements(), this.filter));
    }

    @Override
    public String description() {
        return this.originalCollection.description() + ".filter(" + this.filter + ')';
    }

    @Override
    public Driver driver() {
        return this.originalCollection.driver();
    }

    private static class ConditionPredicate
    implements Predicate<WebElement> {
        private final Driver driver;
        private final Condition filter;

        private ConditionPredicate(Driver driver, Condition filter) {
            this.driver = driver;
            this.filter = filter;
        }

        public boolean apply(@NullableDecl WebElement webElement) {
            return this.filter.apply(this.driver, webElement);
        }

        public String toString() {
            return this.filter.toString();
        }
    }
}

